/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRegistryManagerState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@State(name="DockerRegistry", storages={@Storage(value="docker-registry.xml")})
public class DockerRegistryManager
implements PersistentStateComponent<DockerRegistryManagerState> {
    private List<DockerRegistry> myRegistries = new ArrayList<DockerRegistry>();

    public static DockerRegistryManager getInstance() {
        return (DockerRegistryManager)ServiceManager.getService(DockerRegistryManager.class);
    }

    public List<DockerRegistry> getRegistries() {
        return this.myRegistries;
    }

    @Nullable
    public DockerRegistryManagerState getState() {
        DockerRegistryManagerState state = new DockerRegistryManagerState();
        state.myRegistries.addAll(this.myRegistries);
        return state;
    }

    public void loadState(DockerRegistryManagerState state) {
        this.myRegistries.clear();
        this.myRegistries.addAll(state.myRegistries);
    }

    public void addRegistry(DockerRegistry registry) {
        this.myRegistries.add(registry);
    }

    public void removeRegistry(DockerRegistry registry) {
        this.myRegistries.remove((Object)registry);
    }
}

