/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistrySelectionEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class PullImageConfigurable
implements Configurable {
    private JTextField myTagTextField;
    private JTextField myRepositoryTextField;
    private JPanel myMainPanel;
    private JPanel myRegistrySelectionPanelPlaceholder;
    private final DockerRepositoryModel myModel;
    private RegistrySelectionEditor myRegistrySelectionEditor;

    public PullImageConfigurable(DockerRepositoryModel model) {
        this.myModel = model;
        this.$$$setupUI$$$();
        ArrayList<DockerRegistry> registries = new ArrayList<DockerRegistry>();
        DockerRegistry dockerHubRegistry = new DockerRegistry().withName("registry.hub.docker.com");
        dockerHubRegistry.setAddress("registry.hub.docker.com");
        registries.add(dockerHubRegistry);
        registries.addAll(DockerRegistryManager.getInstance().getRegistries());
        this.myRegistrySelectionEditor = new RegistrySelectionEditor(registries, null);
        this.myRegistrySelectionPanelPlaceholder.add(this.myRegistrySelectionEditor.getMainPanel());
        this.myTagTextField.setText("latest");
    }

    @Nls
    public String getDisplayName() {
        return "Pull Image";
    }

    @Nullable
    public String getHelpTopic() {
        return "Pull_Image_dialog";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        DockerRegistry selectedRegistry = this.myRegistrySelectionEditor.getSelectedAccount();
        if (selectedRegistry == null) {
            throw new ConfigurationException("Registry required");
        }
        String repository = this.myRepositoryTextField.getText();
        if (StringUtil.isEmpty((String)repository)) {
            throw new ConfigurationException("Repository required");
        }
        String tag = this.myTagTextField.getText();
        if (StringUtil.isEmpty((String)tag)) {
            throw new ConfigurationException("Tag required");
        }
        List repositoryParts = StringUtil.split((String)repository, (String)"/");
        if (!selectedRegistry.isDockerHub() && repositoryParts.size() < 2 && StringUtil.isEmpty((String)selectedRegistry.getUsername())) {
            throw new ConfigurationException("Repository namespace (username) required");
        }
        this.myModel.setRegistry(selectedRegistry);
        this.myModel.setRepository(repository);
        this.myModel.setTag(tag);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Repository:");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRepositoryTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRegistrySelectionPanelPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Registry:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Tag:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTagTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel.setLabelFor(jTextField2);
        jBLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

