/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.settings.DockerContainerSettingsEditor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfigurationExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRunConfigurationExtension
extends DeployToServerRunConfigurationExtension {
    @Nullable
    protected String getEditorTitle() {
        return "Container";
    }

    protected boolean isApplicableFor(@NotNull DeployToServerRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/settings/DockerRunConfigurationExtension", "isApplicableFor"));
        }
        return configuration.getServerType() == DockerCloudType.getInstance();
    }

    protected boolean isEnabledFor(@NotNull DeployToServerRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicableConfiguration", "com/intellij/docker/settings/DockerRunConfigurationExtension", "isEnabledFor"));
        }
        return true;
    }

    @Nullable
    protected <P extends DeployToServerRunConfiguration> SettingsEditor<P> createEditor(@NotNull P configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/settings/DockerRunConfigurationExtension", "createEditor"));
        }
        String serverName = configuration.getServerName();
        RemoteServer server = serverName == null ? null : RemoteServersManager.getInstance().findByName(serverName, (ServerType)DockerCloudType.getInstance());
        return new DockerContainerSettingsEditor(configuration.getProject(), server);
    }

    protected void readExternal(@NotNull DeployToServerRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/docker/settings/DockerRunConfigurationExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/settings/DockerRunConfigurationExtension", "readExternal"));
        }
    }

    protected void patchCommandLine(@NotNull DeployToServerRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/settings/DockerRunConfigurationExtension", "patchCommandLine"));
        }
        if (cmdLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdLine", "com/intellij/docker/settings/DockerRunConfigurationExtension", "patchCommandLine"));
        }
        if (runnerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerId", "com/intellij/docker/settings/DockerRunConfigurationExtension", "patchCommandLine"));
        }
    }
}

