/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.settings.DockerPortBindingsEditor;
import com.intellij.docker.view.DockerTableRuntimeEditor;
import com.intellij.docker.view.EmptyDockerAgentContainerConfig;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;

public class DockerPortBindingRuntimeEditor<T>
extends DockerTableRuntimeEditor<DockerPortBindingImpl> {
    private JCheckBox myPublishAllPortsCheckBox;

    public DockerPortBindingRuntimeEditor(DockerAgentContainerConfig config, ParameterizedRunnable<DockerAgentContainerConfig> onSave) {
        super("Port Bindings", new DockerPortBindingsEditor(), onSave);
        Object[] portBindings = config.getPortBindings();
        this.getEditor().setItems(ContainerUtil.map((Object[])(portBindings != null ? portBindings : new DockerPortBinding[]{}), binding -> new DockerPortBindingImpl(binding)));
        this.myPublishAllPortsCheckBox = new JCheckBox("Publish all ports");
        this.getEditorPlaceholder().add((Component)this.myPublishAllPortsCheckBox, "North");
        this.myPublishAllPortsCheckBox.setSelected(config.isPublishAllPorts());
        this.myPublishAllPortsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerPortBindingRuntimeEditor.this.updateVisibility();
            }
        });
        this.updateVisibility();
    }

    @Override
    protected DockerAgentContainerConfig createConfig(final List<DockerPortBindingImpl> items) {
        return new EmptyDockerAgentContainerConfig(){

            @Override
            public DockerPortBinding[] getPortBindings() {
                return items.toArray(new DockerPortBinding[items.size()]);
            }

            @Override
            public Boolean getPublishAllPorts() {
                return DockerPortBindingRuntimeEditor.this.myPublishAllPortsCheckBox.isSelected();
            }
        };
    }

    private void updateVisibility() {
        this.getEditor().setEnabled(!this.myPublishAllPortsCheckBox.isSelected());
    }
}

