/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.docker.view.EmptyDockerAgentContainerConfig;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ParameterizedRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class DockerPropertiesRuntimeEditor
extends DockerRuntimeEditorBase {
    private JButton mySaveButton;
    private JPanel myTablePlaceHolder;
    private JLabel myContainerLabel;
    private JPanel myMainPanel;
    private JComboBox myContainerNamesBox;
    private List<DockerContainerProp> myItems;
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("^[\\/]?[a-zA-Z0-9_.-]+");
    private JBTable myPropsTable;

    public DockerPropertiesRuntimeEditor(DockerAgentContainerConfig config, DockerApplicationRuntime applicationRuntime, ParameterizedRunnable<DockerAgentContainerConfig> onSave) {
        super("Properties", onSave);
        this.$$$setupUI$$$();
        this.myPropsTable = new JBTable();
        this.initControls(this.myMainPanel, this.mySaveButton);
        this.myItems = new ArrayList<DockerContainerProp>();
        this.myItems.add(new DockerContainerProp("Image ID", applicationRuntime.getImageId()));
        String containerId = applicationRuntime.getContainerId();
        if (containerId != null) {
            this.myContainerNamesBox.removeAllItems();
            String[] containerNames = applicationRuntime.getContainerNames();
            String configContainerName = config.getContainerName();
            if (containerNames == null) {
                containerNames = new String[]{configContainerName};
            }
            for (String name : containerNames) {
                this.myContainerNamesBox.addItem(name);
            }
            this.myContainerNamesBox.setSelectedItem(configContainerName);
            this.myItems.add(new DockerContainerProp("Container ID", containerId));
            this.myItems.add(new DockerContainerProp("Container names", StringUtil.join((String[])containerNames, (String)"; ")));
        } else {
            this.hideContainerControls();
            String parentId = applicationRuntime.getImageParentId();
            if (StringUtil.isNotEmpty((String)parentId)) {
                this.myItems.add(new DockerContainerProp("Parent ID", parentId));
            }
            this.myItems.add(new DockerContainerProp("Image Tags", StringUtil.join(applicationRuntime.getImageRepoTags(), (String)"; ")));
        }
        JPanel tableEditor = ToolbarDecorator.createDecorator((JTable)this.myPropsTable).addExtraAction(new AnActionButton("Copy to clipboard", AllIcons.Actions.Copy){

            public void actionPerformed(AnActionEvent e) {
                int selectedIndex = DockerPropertiesRuntimeEditor.this.myPropsTable.getSelectedRow();
                if (selectedIndex == -1) {
                    return;
                }
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((DockerContainerProp)DockerPropertiesRuntimeEditor.this.myItems.get(selectedIndex)).getValue()));
            }
        }).createPanel();
        this.myTablePlaceHolder.add(tableEditor);
        JTableWrapper propsTableWrapper = new JTableWrapper(this.myPropsTable, (Column[])new ColumnBase[]{new NameColumn(), new ValueColumn()});
        propsTableWrapper.setInputRows(this.myItems);
    }

    @Override
    protected DockerAgentContainerConfig createConfig() {
        final String containerName = this.myContainerNamesBox.getEditor().getItem().toString();
        if (this.myContainerNamesBox.getItemCount() > 1 && Messages.showYesNoDialog((Component)this.getMainPanel(), (String)DockerBundle.getText("DockerPropertiesRuntimeEditor.containers.names.warning", new Object[0]), (String)"Changing Container Name", (Icon)Messages.getWarningIcon()) != 1 || this.myContainerNamesBox.getItemCount() == 1) {
            if (!CONTAINER_NAME_PATTERN.matcher(containerName).matches()) {
                Messages.showErrorDialog((String)(containerName.isEmpty() ? "Empty container name is not allowed" : DockerBundle.getText("DockerPropertiesRuntimeEditor.container.name.error", containerName)), (String)"Invalid Container Name");
            } else {
                return new EmptyDockerAgentContainerConfig(){

                    @Override
                    public String getContainerName() {
                        return StringUtil.nullize((String)containerName);
                    }
                };
            }
        }
        return null;
    }

    private void hideContainerControls() {
        this.myContainerLabel.setVisible(false);
        this.myContainerNamesBox.setVisible(false);
        this.mySaveButton.setVisible(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContainerLabel = jLabel = new JLabel();
        jLabel.setText("Container name:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySaveButton = jButton = new JButton();
        jButton.setText("Save");
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myTablePlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myContainerNamesBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(180, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class DockerContainerProp {
        private String myName;
        private String myValue;

        public DockerContainerProp(String name, String value) {
            this.myName = name;
            this.myValue = value;
        }

        public String getName() {
            return this.myName;
        }

        public String getValue() {
            return this.myValue;
        }
    }

    private static class ValueColumn
    extends ColumnBase {
        public ValueColumn() {
            super("Value");
        }

        public Object getColumnValue(DockerContainerProp row) {
            return row.getValue();
        }
    }

    private static class NameColumn
    extends ColumnBase {
        public NameColumn() {
            super("Name");
        }

        public Object getColumnValue(DockerContainerProp row) {
            return row.getName();
        }
    }

    public static abstract class ColumnBase
    extends Column<DockerContainerProp> {
        public ColumnBase(String name) {
            super(name);
        }
    }
}

