/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerComposeDeploymentRuntime;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.view.DockerEnvVarsRuntimeEditor;
import com.intellij.docker.view.DockerPortBindingRuntimeEditor;
import com.intellij.docker.view.DockerPropertiesRuntimeEditor;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.docker.view.DockerTableRuntimeEditor;
import com.intellij.docker.view.DockerTreeFilter;
import com.intellij.docker.view.DockerVolumeBindingsRuntimeEditor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.DockerIcons;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerTreeStructure
extends ServersTreeStructure {
    private static final Key<LoggingHandlerBase> ADDITIONAL_LOG_KEY = Key.create((String)"ADDITIONAL_LOG");
    private final Map<Deployment, DeploymentContent> myDeployment2Content;

    public DockerTreeStructure(@NotNull Project project, @NotNull RemoteServersViewContribution contribution, @NotNull ServersTreeNodeSelector nodeSelector) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/docker/view/DockerTreeStructure", "<init>"));
        }
        if (contribution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contribution", "com/intellij/docker/view/DockerTreeStructure", "<init>"));
        }
        if (nodeSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeSelector", "com/intellij/docker/view/DockerTreeStructure", "<init>"));
        }
        super(project, contribution, nodeSelector);
        this.myDeployment2Content = new HashMap<Deployment, DeploymentContent>();
    }

    protected AbstractTreeNode createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        return new DockerDeploymentNode(connection, serverNode, deployment);
    }

    private class DeploymentContent {
        private final ContentManager myManager;
        private final Deployment myDeployment;
        private boolean myShown = false;
        private boolean myContentInitialized = false;
        private JPanel myLogPanel;
        private Content myLogContent;
        private Content myContainerPropsContent;
        private Content myImagePropsContent;
        private Content myEnvVarsContent;
        private Content myPortBindingContent;
        private Content myVolumeBindingContent;

        public DeploymentContent(Deployment deployment) {
            this.myDeployment = deployment;
            ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
            TabbedPaneContentUI contentUI = new TabbedPaneContentUI(1);
            this.myManager = new ContentManagerImpl((ContentUI)contentUI, true, DockerTreeStructure.this.doGetProject()){

                public boolean canCloseAllContents() {
                    return false;
                }
            };
            this.myManager.addContentManagerListener((ContentManagerListener)new DockerTabContentListener());
            DeploymentLogManagerImpl logManager = this.getLogManager();
            if (logManager != null && logManager.isMainHandlerVisible()) {
                Content content = contentFactory.createContent(logManager.getMainLoggingHandler().getConsole().getComponent(), "Deploy log", true);
                content.setCloseable(false);
                this.myManager.addContent(content);
            }
        }

        public ContentManager getManager() {
            return this.myManager;
        }

        private DeploymentLogManagerImpl getLogManager() {
            return (DeploymentLogManagerImpl)this.myDeployment.getConnection().getLogManager(this.myDeployment);
        }

        private DockerApplicationRuntime getRuntime() {
            return (DockerApplicationRuntime)this.myDeployment.getRuntime();
        }

        public void show() {
            if (this.myShown) {
                return;
            }
            this.myShown = true;
            this.initContent();
        }

        public void initContent() {
            if (this.myContentInitialized || !this.myShown) {
                return;
            }
            DockerApplicationRuntime applicationRuntime = this.getRuntime();
            if (applicationRuntime == null) {
                return;
            }
            if (applicationRuntime.getContainerId() != null) {
                this.doInitContainerContent();
                this.myContentInitialized = true;
            } else if (applicationRuntime.getImageId() != null) {
                this.doInitImageContent();
                this.myContentInitialized = true;
            }
        }

        private void doInitContainerContent() {
            this.removeOldContent(this.myLogContent);
            this.removeOldContent(this.myEnvVarsContent);
            this.removeOldContent(this.myPortBindingContent);
            this.removeOldContent(this.myVolumeBindingContent);
            this.removeOldContent(this.myContainerPropsContent);
            this.myLogPanel = new JPanel();
            this.myLogPanel.setLayout(new BorderLayout());
            this.myLogContent = this.myManager.getFactory().createContent((JComponent)this.myLogPanel, "Log", true);
            this.myLogContent.setCloseable(false);
            this.myManager.addContent(this.myLogContent);
            DockerApplicationRuntime applicationRuntime = this.getRuntime();
            applicationRuntime.showLog(DockerTreeStructure.this.doGetProject(), EmptyRunnable.getInstance());
            applicationRuntime.inspect((ParameterizedRunnable<DockerAgentContainerConfig>)((ParameterizedRunnable)config -> UIUtil.invokeLaterIfNeeded(() -> {
                this.myContainerPropsContent = new EditorContentCreator((DockerAgentContainerConfig)config, applicationRuntime){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    final /* synthetic */ DockerApplicationRuntime val$applicationRuntime;
                    {
                        this.val$config = dockerAgentContainerConfig;
                        this.val$applicationRuntime = dockerApplicationRuntime;
                    }

                    @Override
                    protected DockerRuntimeEditorBase createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerPropertiesRuntimeEditor(this.val$config, this.val$applicationRuntime, callback);
                    }
                }.createContent();
                this.myEnvVarsContent = new EditorContentCreator((DockerAgentContainerConfig)config){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    {
                        this.val$config = dockerAgentContainerConfig;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerEnvVarsRuntimeEditor(this.val$config, callback);
                    }
                }.createContent();
                this.myPortBindingContent = new EditorContentCreator((DockerAgentContainerConfig)config){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    {
                        this.val$config = dockerAgentContainerConfig;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerPortBindingRuntimeEditor(this.val$config, callback);
                    }
                }.createContent();
                this.myVolumeBindingContent = new EditorContentCreator((DockerAgentContainerConfig)config){
                    final /* synthetic */ DockerAgentContainerConfig val$config;
                    {
                        this.val$config = dockerAgentContainerConfig;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                        return new DockerVolumeBindingsRuntimeEditor(this.val$config, callback, DeploymentContent.this.myDeployment.getConnection().getServer());
                    }
                }.createContent();
            })));
        }

        private void removeOldContent(Content content) {
            if (content != null) {
                this.myManager.removeFromSelection(content);
                this.myManager.removeContent(content, true);
            }
        }

        private void selectContainerLog() {
            ServerConnection connection = this.myDeployment.getConnection();
            connection.computeDeployments(() -> UIUtil.invokeLaterIfNeeded(() -> {
                String newContainerId = this.getRuntime().getContainerId();
                ServerConnection connection1 = this.myDeployment.getConnection();
                for (Deployment newDeployment : connection1.getDeployments()) {
                    DeploymentRuntime newDeploymentRuntime = newDeployment.getRuntime();
                    if (newDeploymentRuntime == null || !StringUtil.equals((CharSequence)((DockerApplicationRuntime)newDeploymentRuntime).getContainerId(), (CharSequence)newContainerId)) continue;
                    DockerTreeStructure.this.getNodeSelector().select(connection1, newDeployment.getName(), "Log");
                }
            }));
        }

        private void doInitImageContent() {
            this.removeOldContent(this.myImagePropsContent);
            this.myImagePropsContent = new EditorContentCreator(){

                @Override
                protected DockerRuntimeEditorBase createEditor(ParameterizedRunnable<DockerAgentContainerConfig> callback) {
                    return new DockerPropertiesRuntimeEditor(null, DeploymentContent.this.getRuntime(), null);
                }
            }.createContent();
        }

        public void updateLogs() {
            DeploymentLogManagerImpl logManager = this.getLogManager();
            if (logManager == null || !this.myContentInitialized) {
                return;
            }
            for (LoggingHandlerBase loggingHandler : logManager.getAdditionalLoggingHandlers()) {
                if (StringUtil.equals((CharSequence)"Log", (CharSequence)loggingHandler.getPresentableName()) && this.myLogPanel.getComponentCount() == 0) {
                    this.myLogPanel.add(loggingHandler.getComponent());
                    this.myLogContent.putUserData(ADDITIONAL_LOG_KEY, (Object)loggingHandler);
                    continue;
                }
                if (this.findAdditionalLogContent(loggingHandler) != null || Disposer.isDisposed((Disposable)loggingHandler)) continue;
                Content content = this.myManager.getFactory().createContent(loggingHandler.getComponent(), loggingHandler.getPresentableName(), true);
                content.putUserData(ADDITIONAL_LOG_KEY, (Object)loggingHandler);
                this.myManager.addContent(content);
            }
        }

        private Content findAdditionalLogContent(LoggingHandlerBase loggingHandler) {
            for (Content content : this.myManager.getContents()) {
                LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
                if (additionalLog != loggingHandler) continue;
                return content;
            }
            return null;
        }

        private class DockerTabContentListener
        extends ContentManagerAdapter {
            private DockerTabContentListener() {
            }

            public void contentRemoved(ContentManagerEvent event) {
                Content content = event.getContent();
                LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
                TerminalHandlerBase terminalHandler = (TerminalHandlerBase)ObjectUtils.tryCast((Object)additionalLog, TerminalHandlerBase.class);
                if (terminalHandler != null) {
                    terminalHandler.close();
                }
                if (additionalLog != null && content.isCloseable()) {
                    Disposer.dispose((Disposable)additionalLog);
                }
            }
        }

        private abstract class EditorContentCreator {
            private EditorContentCreator() {
            }

            public Content createContent() {
                DockerRuntimeEditorBase editor = this.createEditor((ParameterizedRunnable<DockerAgentContainerConfig>)((ParameterizedRunnable)config -> DeploymentContent.this.getRuntime().updateContainer((DockerAgentContainerConfig)config, () -> {
                    DeploymentContent.this.myContentInitialized = false;
                    DeploymentContent.this.selectContainerLog();
                })));
                Content result = DeploymentContent.this.myManager.getFactory().createContent((JComponent)editor.getMainPanel(), editor.getName(), true);
                result.setCloseable(false);
                DeploymentContent.this.myManager.addContent(result);
                return result;
            }

            protected abstract DockerRuntimeEditorBase createEditor(ParameterizedRunnable<DockerAgentContainerConfig> var1);
        }
    }

    public class DockerDeploymentNode
    extends ServersTreeStructure.DeploymentNodeImpl {
        private final DeploymentContent myContent;

        protected DockerDeploymentNode(@NotNull ServerConnection<?> connection, @NotNull ServersTreeStructure.RemoteServerNode serverNode, final Deployment value) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode", "<init>"));
            }
            if (serverNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverNode", "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode", "<init>"));
            }
            super((ServersTreeStructure)DockerTreeStructure.this, connection, serverNode, value);
            this.myContent = (DeploymentContent)ContainerUtil.getOrCreate((Map)DockerTreeStructure.this.myDeployment2Content, (Object)value, (Factory)new Factory<DeploymentContent>(){

                public DeploymentContent create() {
                    return new DeploymentContent(value);
                }
            });
            this.myContent.initContent();
            this.myContent.updateLogs();
        }

        @Nullable
        public JComponent getComponent() {
            this.myContent.show();
            return this.myContent.getManager().getComponent();
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList result = new ArrayList();
            this.collectDeploymentChildren(result);
            Collection collection = result.stream().filter(DockerTreeFilter.getInstance()::acceptNode).collect(Collectors.toList());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode", "getChildren"));
            }
            return collection;
        }

        public void selectLog(String logName) {
            ContentManager contentManager = this.myContent.getManager();
            for (Content content : contentManager.getContents()) {
                LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
                if (additionalLog == null || !StringUtil.equals((CharSequence)additionalLog.getPresentableName(), (CharSequence)logName)) continue;
                contentManager.setSelectedContent(content);
                return;
            }
        }

        protected void update(PresentationData presentation) {
            DockerComposeDeploymentRuntime.ServiceRuntime serviceRuntime;
            super.update(presentation);
            Deployment deployment = this.getDeployment();
            if (deployment.getStatus() == DeploymentStatus.DEPLOYED) {
                presentation.setIcon(DockerIcons.SingleRunningContainer);
            }
            if ((serviceRuntime = (DockerComposeDeploymentRuntime.ServiceRuntime)((Object)ObjectUtils.tryCast((Object)deployment.getRuntime(), DockerComposeDeploymentRuntime.ServiceRuntime.class))) != null) {
                presentation.setPresentableText(serviceRuntime.getServiceName());
            }
        }
    }
}

