/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.kqueue.KQueueChannelConfig;

final class KQueueRecvByteAllocatorHandle
extends RecvByteBufAllocator.DelegatingHandle {
    private final KQueueChannelConfig config;
    private boolean readEOF;
    private long numberBytesPending;

    KQueueRecvByteAllocatorHandle(RecvByteBufAllocator.Handle handle, KQueueChannelConfig config) {
        super(handle);
        this.config = config;
    }

    @Override
    public int guess() {
        return this.config.getRcvAllocTransportProvidesGuess() ? this.guess0() : this.delegate().guess();
    }

    @Override
    public ByteBuf allocate(ByteBufAllocator alloc) {
        return this.config.getRcvAllocTransportProvidesGuess() ? alloc.ioBuffer(this.guess0()) : this.delegate().allocate(alloc);
    }

    @Override
    public void lastBytesRead(int bytes) {
        this.numberBytesPending = bytes < 0 ? 0L : Math.max(0L, this.numberBytesPending - (long)bytes);
        this.delegate().lastBytesRead(bytes);
    }

    @Override
    public boolean continueReading() {
        return this.readEOF || this.maybeMoreDataToRead() && this.delegate().continueReading();
    }

    void readEOF() {
        this.readEOF = true;
    }

    void numberBytesPending(long numberBytesPending) {
        this.numberBytesPending = numberBytesPending;
    }

    boolean maybeMoreDataToRead() {
        return this.numberBytesPending != 0L;
    }

    private int guess0() {
        return (int)Math.min(this.numberBytesPending, Integer.MAX_VALUE);
    }
}

