/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.codeInsight;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateActionContext {
    private final JSFile myJsFile;
    private final Editor myEditor;
    private final int myDocumentCaretOffset;

    GenerateActionContext(@NotNull JSFile jsFile, @NotNull Editor editor) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "<init>"));
        }
        this.myJsFile = jsFile;
        this.myEditor = editor;
        this.myDocumentCaretOffset = this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public JSFile getJsFile() {
        JSFile jSFile = this.myJsFile;
        if (jSFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "getJsFile"));
        }
        return jSFile;
    }

    public int getDocumentCaretOffset() {
        return this.myDocumentCaretOffset;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "getEditor"));
        }
        return editor;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myEditor.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "getDocument"));
        }
        return document;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myJsFile.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "getProject"));
        }
        return project;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditor.getCaretModel();
        if (caretModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "getCaretModel"));
        }
        return caretModel;
    }

    @Nullable
    public PsiElement getPsiElementUnderCaret() {
        PsiElement element = this.myJsFile.findElementAt(this.getDocumentCaretOffset());
        if (element == null) {
            element = this.myJsFile.getLastChild();
        }
        return element;
    }

    public void startTemplate(@NotNull Template template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/javascript/testFramework/codeInsight/GenerateActionContext", "startTemplate"));
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)this.getProject());
        templateManager.startTemplate(this.getEditor(), "", template);
    }
}

