/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.coverage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.coverage.PathConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LcovCoverageReport {
    private final Map<String, List<LineHits>> myInfo = Maps.newHashMap();

    @NotNull
    public Map<String, List<LineHits>> getInfo() {
        Map<String, List<LineHits>> map = this.myInfo;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "getInfo"));
        }
        return map;
    }

    public void mergeReport(@NotNull LcovCoverageReport report) {
        if (report == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "mergeReport"));
        }
        for (Map.Entry<String, List<LineHits>> entry : report.getInfo().entrySet()) {
            this.mergeFileReport(null, entry.getKey(), entry.getValue());
        }
    }

    public void mergeFileReport(@Nullable File basePath, @NotNull String filePath, @NotNull List<LineHits> report) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "mergeFileReport"));
        }
        if (report == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "mergeFileReport"));
        }
        File file = new File(filePath);
        if (!file.isAbsolute() && basePath != null) {
            file = new File(basePath, filePath);
        }
        String normalizedFilePath = PathConverter.getNormalizedPath(file);
        LcovCoverageReport.normalizeLineHitsList(report);
        List<LineHits> old = this.myInfo.get(normalizedFilePath);
        if (old != null) {
            LcovCoverageReport.doMerge(old, report);
        } else {
            this.myInfo.put(normalizedFilePath, report);
        }
    }

    public void clearReportByFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "clearReportByFilePath"));
        }
        this.myInfo.remove(filePath);
    }

    private static List<LineHits> doMerge(@NotNull List<LineHits> aList, @NotNull List<LineHits> bList) {
        if (aList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aList", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "doMerge"));
        }
        if (bList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bList", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "doMerge"));
        }
        PeekingIterator ai = new PeekingIterator(aList.iterator());
        PeekingIterator bi = new PeekingIterator(bList.iterator());
        ArrayList out = Lists.newArrayList();
        while (ai.hasNext() && bi.hasNext()) {
            LineHits x;
            LineHits a = (LineHits)ai.peek();
            LineHits b = (LineHits)bi.peek();
            if (a.getLineNumber() < b.getLineNumber()) {
                x = (LineHits)ai.next();
            } else if (a.getLineNumber() > b.getLineNumber()) {
                x = (LineHits)bi.next();
            } else {
                a.addHits(b.getHits());
                x = a;
                ai.next();
                bi.next();
            }
            out.add(x);
        }
        LcovCoverageReport.addRestItems(out, ai);
        LcovCoverageReport.addRestItems(out, bi);
        return out;
    }

    private static <T> void addRestItems(@NotNull List<T> out, Iterator<T> iterator) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "addRestItems"));
        }
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
    }

    private static void normalizeLineHitsList(@NotNull List<LineHits> lineHitsList) {
        if (lineHitsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineHitsList", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "normalizeLineHitsList"));
        }
        LcovCoverageReport.makeSortedByLineNumber(lineHitsList);
        LcovCoverageReport.makeUniqueByLineNumber(lineHitsList);
    }

    private static void makeSortedByLineNumber(@NotNull List<LineHits> report) {
        if (report == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "makeSortedByLineNumber"));
        }
        LineHits prev = null;
        for (LineHits cur : report) {
            if (prev != null && prev.getLineNumber() > cur.getLineNumber()) {
                Collections.sort(report);
                return;
            }
            prev = cur;
        }
    }

    private static void makeUniqueByLineNumber(@NotNull List<LineHits> report) {
        if (report == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "makeUniqueByLineNumber"));
        }
        boolean unique = LcovCoverageReport.checkForLineUniqueness(report);
        if (unique) {
            return;
        }
        ArrayList<LineHits> out = new ArrayList<LineHits>(report.size());
        LineHits prev = null;
        for (LineHits cur : report) {
            if (prev != null && prev.getLineNumber() == cur.getLineNumber()) {
                prev.addHits(cur.getHits());
                continue;
            }
            out.add(cur);
            prev = cur;
        }
        report.clear();
        report.addAll(out);
    }

    private static boolean checkForLineUniqueness(@NotNull List<LineHits> lineHitsList) {
        if (lineHitsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineHitsList", "com/intellij/javascript/testFramework/coverage/LcovCoverageReport", "checkForLineUniqueness"));
        }
        LineHits prev = null;
        for (LineHits cur : lineHitsList) {
            if (prev != null && prev.getLineNumber() == cur.getLineNumber()) {
                return false;
            }
            prev = cur;
        }
        return true;
    }

    private static class PeekingIterator<T>
    implements Iterator<T> {
        private final Iterator<T> myIterator;
        private T myValue = null;
        private boolean myValidValue = false;

        private PeekingIterator(Iterator<T> iterator) {
            this.myIterator = iterator;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.myValidValue;
        }

        @Override
        public T next() {
            if (this.myValidValue) {
                T save = this.myValue;
                this.advance();
                return save;
            }
            throw new NoSuchElementException();
        }

        public T peek() {
            if (this.myValidValue) {
                return this.myValue;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            this.myValidValue = this.myIterator.hasNext();
            this.myValue = this.myValidValue ? this.myIterator.next() : null;
        }
    }

    public static class LineHits
    implements Comparable<LineHits> {
        private final int myLineNumber;
        private int myHits;

        public LineHits(int lineNumber, int hits) {
            this.myLineNumber = lineNumber;
            this.myHits = hits;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getHits() {
            return this.myHits;
        }

        @Override
        public int compareTo(LineHits o) {
            return this.myLineNumber - o.myLineNumber;
        }

        public void addHits(int hitCount) {
            this.myHits += hitCount;
        }
    }
}

