/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.exports;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.exports.ExportsNode;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportsTestFileStructure
extends AbstractTestFileStructure {
    private ExportsNode myRoot;

    public ExportsTestFileStructure(@NotNull JSFile file, @NotNull ExportsNode root) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "<init>"));
        }
        super(file);
        this.myRoot = root;
    }

    @Override
    public boolean isEmpty() {
        return this.myRoot.isEmpty();
    }

    public ExportsNode getRoot() {
        return this.myRoot;
    }

    @Override
    @Nullable
    public JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "findJstdRunElement"));
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findPsiElement(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "findPsiElement"));
        }
        return this.findPsiElement(ContainerUtil.newArrayList((Object[])new String[]{testCaseName, testMethodName}));
    }

    @Override
    @NotNull
    public List<String> getTopLevelElements() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "getTopLevelElements"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getChildrenOf(@NotNull String topLevelElementName) {
        if (topLevelElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelElementName", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "getChildrenOf"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "getChildrenOf"));
        }
        return list;
    }

    @Override
    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "contains"));
        }
        return this.findPsiElement(testCaseName, testMethodName) != null;
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull List<String> path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/testFramework/exports/ExportsTestFileStructure", "findPsiElement"));
        }
        if (path.isEmpty()) {
            return null;
        }
        ExportsNode node = this.myRoot;
        for (String name : path) {
            ExportsNode child = node.getChild(name);
            if (child == null) {
                return null;
            }
            node = child;
        }
        return node.getNavigateTo();
    }
}

