/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJasmineElement {
    private final String myName;
    private final JasmineSuiteStructure myParent;

    public AbstractJasmineElement(@NotNull String name, @Nullable JasmineSuiteStructure parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/jasmine/AbstractJasmineElement", "<init>"));
        }
        this.myName = name;
        this.myParent = parent;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/AbstractJasmineElement", "getName"));
        }
        return string;
    }

    @Nullable
    public JasmineSuiteStructure getParent() {
        return this.myParent;
    }

    @NotNull
    static PsiElement getNavigationElement(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/javascript/testFramework/jasmine/AbstractJasmineElement", "getNavigationElement"));
        }
        JSExpression arg = (JSExpression)ArrayUtil.getFirstElement((Object[])callExpression.getArguments());
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)arg, (Object)callExpression);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/AbstractJasmineElement", "getNavigationElement"));
        }
        return psiElement;
    }
}

