/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineFileStructureBuilder
extends AbstractTestFileStructureBuilder<JasmineFileStructure> {
    private static final JasmineFileStructureBuilder INSTANCE = new JasmineFileStructureBuilder();
    public static final String DESCRIBE_NAME = "describe";
    public static final String CONTEXT_NAME = "context";
    public static final String DDESCRIBE_NAME = "ddescribe";
    public static final String XDESCRIBE_NAME = "xdescribe";
    public static final String FDESCRIBE_NAME = "fdescribe";
    public static final String IT_NAME = "it";
    public static final String TEST_NAME = "test";
    public static final String IIT_NAME = "iit";
    public static final String XIT_NAME = "xit";
    public static final String FIT_NAME = "fit";

    @Override
    @NotNull
    public JasmineFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder", "buildTestFileStructure"));
        }
        JasmineFileStructure jasmineFileStructure = new Builder(jsFile).build();
        if (jasmineFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder", "buildTestFileStructure"));
        }
        return jasmineFileStructure;
    }

    public static JasmineFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    private static class Builder {
        private final JasmineFileStructure myFileStructure;

        public Builder(JSFile jsFile) {
            this.myFileStructure = new JasmineFileStructure(jsFile);
        }

        public JasmineFileStructure build() {
            if (this.isJasmineFile()) {
                List<JSStatement> statements = JsPsiUtils.listStatementsInExecutionOrder(this.myFileStructure.getJsFile());
                for (JSStatement statement : statements) {
                    JSCallExpression jsCallExpression = JsPsiUtils.toCallExpressionFromStatement(statement);
                    if (jsCallExpression == null) continue;
                    this.handleCallExpr(null, jsCallExpression);
                }
            }
            this.myFileStructure.postProcess();
            return this.myFileStructure;
        }

        private boolean isJasmineFile() {
            return JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.DESCRIBE_NAME, true) || JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.CONTEXT_NAME, true) || JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.IT_NAME, true) || JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), JasmineFileStructureBuilder.TEST_NAME, true);
        }

        private void handleCallExpr(@Nullable JasmineSuiteStructure parentSuiteStructure, @NotNull JSCallExpression callExpression) {
            JSExpression qualifier;
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder$Builder", "handleCallExpr"));
            }
            JSReferenceExpression methodExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
            JSReferenceExpression methodKeyExpr = null;
            if (methodExpr != null && (qualifier = methodExpr.getQualifier()) instanceof JSReferenceExpression) {
                methodKeyExpr = methodExpr;
                methodExpr = (JSReferenceExpression)qualifier;
            }
            JSArgumentList argumentList = callExpression.getArgumentList();
            if (methodExpr != null && methodExpr.getQualifier() == null && argumentList != null) {
                String name;
                JSExpression[] arguments = argumentList.getArguments();
                if (arguments.length != 2) {
                    return;
                }
                String methodName = methodExpr.getReferenceName();
                if (Builder.isSuiteMethodName(methodName) && Builder.isSuiteMethodKeyName(methodKeyExpr)) {
                    name = JsPsiUtils.extractStringValue(arguments[0]);
                    JSFunctionExpression specDefinitions = JsPsiUtils.extractFunctionExpression(arguments[1]);
                    if (name != null && specDefinitions != null) {
                        JasmineSuiteStructure suiteStructure = new JasmineSuiteStructure(name, callExpression, specDefinitions, parentSuiteStructure);
                        if (parentSuiteStructure != null) {
                            parentSuiteStructure.addChild(suiteStructure);
                        } else {
                            this.myFileStructure.addSuiteStructure(suiteStructure);
                        }
                        this.handleSuite(suiteStructure, specDefinitions);
                    }
                }
                if (Builder.isSpecMethodName(methodName) && (name = JsPsiUtils.extractStringValue(arguments[0])) != null) {
                    JasmineSpecStructure specStructure = new JasmineSpecStructure(name, callExpression, parentSuiteStructure);
                    if (parentSuiteStructure != null) {
                        parentSuiteStructure.addChild(specStructure);
                    } else {
                        this.myFileStructure.addSpecStructure(specStructure);
                    }
                }
            }
        }

        private static boolean isSuiteMethodName(@Nullable String methodName) {
            return JasmineFileStructureBuilder.DESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.CONTEXT_NAME.equals(methodName) || JasmineFileStructureBuilder.DDESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.FDESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.XDESCRIBE_NAME.equals(methodName);
        }

        private static boolean isSuiteMethodKeyName(@Nullable JSReferenceExpression methodKeyExpr) {
            if (methodKeyExpr != null) {
                String methodKeyName = methodKeyExpr.getReferenceName();
                return "skip".equals(methodKeyName) || "only".equals(methodKeyName);
            }
            return true;
        }

        private static boolean isSpecMethodName(String methodName) {
            return JasmineFileStructureBuilder.IT_NAME.equals(methodName) || JasmineFileStructureBuilder.TEST_NAME.equals(methodName) || JasmineFileStructureBuilder.IIT_NAME.equals(methodName) || JasmineFileStructureBuilder.FIT_NAME.equals(methodName) || JasmineFileStructureBuilder.XIT_NAME.equals(methodName);
        }

        private void handleSuite(@NotNull JasmineSuiteStructure suiteStructure, @NotNull JSFunctionExpression specDefinitions) {
            JSSourceElement[] sourceElements;
            if (suiteStructure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteStructure", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder$Builder", "handleSuite"));
            }
            if (specDefinitions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specDefinitions", "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder$Builder", "handleSuite"));
            }
            for (JSSourceElement sourceElement : sourceElements = (JSSourceElement[])ObjectUtils.notNull((Object)specDefinitions.getBody(), (Object)JSSourceElement.EMPTY_ARRAY)) {
                JSStatement[] statements;
                JSBlockStatement jsBlockStatement = (JSBlockStatement)ObjectUtils.tryCast((Object)sourceElement, JSBlockStatement.class);
                if (jsBlockStatement == null) continue;
                for (JSStatement statement : statements = (JSStatement[])ObjectUtils.notNull((Object)jsBlockStatement.getStatements(), (Object)JSStatement.EMPTY)) {
                    JSCallExpression jsCallExpression = JsPsiUtils.toCallExpressionFromStatement(statement);
                    if (jsCallExpression == null) continue;
                    this.handleCallExpr(suiteStructure, jsCallExpression);
                }
            }
        }
    }
}

