/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine.codeInsight;

import com.intellij.codeInsight.template.Template;
import com.intellij.javascript.testFramework.codeInsight.AbstractJsGenerateAction;
import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.javascript.testFramework.codeInsight.JsGeneratorUtils;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineGenerateNewSuiteAction
extends AbstractJsGenerateAction {
    @Override
    @NotNull
    public String getHumanReadableDescription() {
        if ("Jasmine Suite" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "getHumanReadableDescription"));
        }
        return "Jasmine Suite";
    }

    @Override
    public boolean isEnabled(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "isEnabled"));
        }
        Runnable generator = JasmineGenerateNewSuiteAction.createGenerator(context);
        return generator != null;
    }

    @Override
    public void actionPerformed(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "actionPerformed"));
        }
        Runnable generator = JasmineGenerateNewSuiteAction.createGenerator(context);
        if (generator != null) {
            generator.run();
        }
    }

    @Nullable
    private static Runnable createGenerator(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "createGenerator"));
        }
        JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
        JasmineFileStructure fileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure(context.getJsFile());
        return JasmineGenerateNewSuiteAction.createGenerator(context, fileStructure);
    }

    @Nullable
    private static Runnable createGenerator(@NotNull GenerateActionContext context, @NotNull JasmineFileStructure fileStructure) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "createGenerator"));
        }
        if (fileStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStructure", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "createGenerator"));
        }
        if (fileStructure.hasJasmineSymbols()) {
            PsiElement psiElementUnderCaret = context.getPsiElementUnderCaret();
            if (psiElementUnderCaret == null) {
                return null;
            }
            return () -> {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "lambda$createGenerator$0"));
                }
                if (fileStructure == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStructure", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "lambda$createGenerator$0"));
                }
                int caretOffset = context.getDocumentCaretOffset();
                PsiElement element = JasmineGenerateNewSuiteAction.getPrecedingPsiElement(fileStructure, psiElementUnderCaret, caretOffset);
                int suitableCaretOffset = JsGeneratorUtils.findSuitableOffsetForNewStatement(element, caretOffset);
                context.getCaretModel().moveToOffset(suitableCaretOffset);
                String name = JsPsiUtils.wrapWithMostFrequentQuote(context.getJsFile(), "${suite name}");
                Template template = JsGeneratorUtils.createDefaultTemplate("describe(" + name + ", function() {|});");
                context.startTemplate(template);
            };
        }
        return null;
    }

    @NotNull
    private static PsiElement getPrecedingPsiElement(@NotNull JasmineFileStructure fileStructure, @NotNull PsiElement psiElementUnderCaret, int caretOffset) {
        if (fileStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStructure", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "getPrecedingPsiElement"));
        }
        if (psiElementUnderCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementUnderCaret", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "getPrecedingPsiElement"));
        }
        JasmineSpecStructure specStructure = fileStructure.findSpecContainingOffset(caretOffset);
        if (specStructure != null) {
            JSCallExpression jSCallExpression = specStructure.getEnclosingCallExpression();
            if (jSCallExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "getPrecedingPsiElement"));
            }
            return jSCallExpression;
        }
        PsiElement psiElement = psiElementUnderCaret;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/codeInsight/JasmineGenerateNewSuiteAction", "getPrecedingPsiElement"));
        }
        return psiElement;
    }
}

