/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.codeInsight.completion.XmlAttributeReferenceCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JadeCompletionContributor
extends CompletionContributor {
    private static final String[] STATEMENTS = new String[]{"if", "else", "else if", "until", "while", "unless", "each", "for", "case", "when", "include", "extends", "doctype", "default", "yield"};
    private static final String[] TAGS_WITHOUT_CLASSES_COMPLETION = new String[]{"script", "style"};
    private static final InsertHandler<LookupElement> NAME_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (!CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=")) {
                String toInsert = "=";
                document.insertString(caretOffset, (CharSequence)toInsert);
                if ('=' == context.getCompletionChar()) {
                    context.setAddCompletionChar(false);
                }
            }
            editor.getCaretModel().moveToOffset(caretOffset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
    };

    public JadeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)XmlPatterns.xmlTag()), new JadeTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttribute()), new JadeAttributeCompletionProvider());
    }

    private static boolean shouldProhibitClassCompletion(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/plugins/jade/JadeCompletionContributor", "shouldProhibitClassCompletion"));
        }
        PsiElement elementOfCompletion = parameters.getPosition();
        XmlTag tagElement = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementOfCompletion, XmlTag.class);
        int offset = parameters.getOffset();
        assert (tagElement != null) : "Attribute is inside the tag";
        assert (offset > 0);
        if (parameters.getEditor().getDocument().getImmutableCharSequence().charAt(offset - 1) != '.') {
            return false;
        }
        return ArrayUtil.contains((String)tagElement.getLocalName(), (String[])TAGS_WITHOUT_CLASSES_COMPLETION);
    }

    private static class JadeAttributeCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private JadeAttributeCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/plugins/jade/JadeCompletionContributor$JadeAttributeCompletionProvider", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/plugins/jade/JadeCompletionContributor$JadeAttributeCompletionProvider", "addCompletions"));
            }
            if (parameters.getInvocationCount() == 0 && JadeCompletionContributor.shouldProhibitClassCompletion(parameters)) {
                result.stopHere();
                return;
            }
            PsiElement elementOfCompletion = parameters.getPosition();
            PsiReference reference = elementOfCompletion.getContainingFile().findReferenceAt(parameters.getOffset());
            if (reference instanceof XmlAttributeReference) {
                XmlAttributeReferenceCompletionProvider.addAttributeReferenceCompletionVariants((XmlAttributeReference)((XmlAttributeReference)reference), (CompletionResultSet)result, (InsertHandler)NAME_INSERT_HANDLER);
                result.stopHere();
            }
        }
    }

    private static class JadeTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private JadeTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            LookupElement[] tags;
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/plugins/jade/JadeCompletionContributor$JadeTagCompletionProvider", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/plugins/jade/JadeCompletionContributor$JadeTagCompletionProvider", "addCompletions"));
            }
            PsiElement elementOfCompletion = parameters.getPosition();
            XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementOfCompletion, XmlTag.class);
            assert (element != null) : "Pattern says that parent is a tag";
            for (LookupElement lookupElement : tags = TagNameReferenceCompletionProvider.getTagNameVariants((XmlTag)element, (String)element.getNamespacePrefix())) {
                result.consume(lookupElement);
            }
            for (final String string : STATEMENTS) {
                result.consume((LookupElement)LookupElementBuilder.create((String)string).bold().withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        if (context.getCompletionChar() == ' ') {
                            return;
                        }
                        if ("else".equals(string) || "default".equals(string) || "yield".equals(string)) {
                            return;
                        }
                        Project project = context.getProject();
                        Editor editor = context.getEditor();
                        int offset = editor.getCaretModel().getOffset();
                        editor.getDocument().insertString(offset, (CharSequence)" ");
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                        editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                    }
                }));
            }
        }
    }
}

