/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.lexer.IndentUtil;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import com.jetbrains.plugins.jade.psi.impl.JadePipedTextImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!(file instanceof JadeFileImpl)) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyleSettingsManager.getSettings((Project)editor.getProject()).getCommonSettings((Language)JadeLanguage.INSTANCE).getIndentOptions();
        if (indentOptions == null && (indentOptions = CodeStyleSettingsManager.getSettings((Project)editor.getProject()).getIndentOptions()) == null) {
            Logger.getInstance(JadeCopyPasteProcessor.class).error("indent options are null");
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        String normalizedText = Character.isWhitespace(text.charAt(0)) || JadeCopyPasteProcessor.someLineExceptFirstOneDoesntStartWithWhiteSpace(text) ? this.processTextWithLeadingWhitespace(text, indentOptions) : text;
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        PsiElement containingElement = file.findElementAt(Math.max(0, caretOffset - 1));
        if (containingElement == null) {
            String string = normalizedText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        String firstLineIndent = JadeCopyPasteProcessor.getIndentBefore(document, caretOffset);
        IElementType containingElementType = containingElement.getNode().getElementType();
        if (containingElementType == JadeTokenTypes.TEXT || PsiTreeUtil.getParentOfType((PsiElement)containingElement, JadePipedTextImpl.class) != null) {
            String string = JadeCopyPasteProcessor.appendToLines(normalizedText, firstLineIndent + " | ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "preprocessOnPaste"));
            }
            return string;
        }
        String string = JadeCopyPasteProcessor.appendToLines(normalizedText, firstLineIndent);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "preprocessOnPaste"));
        }
        return string;
    }

    @NotNull
    private static String appendToLines(@NotNull String text, @NotNull String toAppend) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "appendToLines"));
        }
        if (toAppend == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAppend", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "appendToLines"));
        }
        String string = StringUtil.join((Collection)StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false), (String)("\n" + toAppend));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "appendToLines"));
        }
        return string;
    }

    @NotNull
    private static String getIndentBefore(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "getIndentBefore"));
        }
        CharSequence s = document.getCharsSequence();
        int lastEol = StringUtil.lastIndexOf((CharSequence)s, (char)'\n', (int)0, (int)offset);
        StringBuilder result = new StringBuilder();
        for (int i = lastEol + 1; i < offset && Character.isWhitespace(s.charAt(i)); ++i) {
            result.append(s.charAt(i));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "getIndentBefore"));
        }
        return string;
    }

    @NotNull
    public String processTextWithLeadingWhitespace(@NotNull String text, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "processTextWithLeadingWhitespace"));
        }
        if (indentOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOptions", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "processTextWithLeadingWhitespace"));
        }
        List lines = StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false);
        int minIndent = Integer.MAX_VALUE;
        for (String line : lines) {
            if (line.isEmpty()) continue;
            minIndent = Math.min(minIndent, IndentUtil.calcIndent(line, 0, indentOptions.TAB_SIZE));
        }
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (result.length() > 0) {
                result.append("\n");
            }
            int curIndent = IndentUtil.calcIndent(line, 0, indentOptions.TAB_SIZE);
            result.append(StringUtil.repeat((String)" ", (int)Math.max(0, curIndent - minIndent))).append(StringUtil.trimLeading((String)line));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeCopyPasteProcessor", "processTextWithLeadingWhitespace"));
        }
        return string;
    }

    private static boolean someLineExceptFirstOneDoesntStartWithWhiteSpace(String text) {
        List lines = StringUtil.split((String)text, (String)"\n");
        for (int i = 1; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (Character.isWhitespace(line.charAt(0))) continue;
            return true;
        }
        return false;
    }
}

