/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.jetbrains.plugins.jade.JadeLanguage;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeFileViewProvider
extends SingleRootFileViewProvider {
    private static final Set<Language> LANGUAGES = Collections.singleton(JadeLanguage.INSTANCE);

    public JadeFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/plugins/jade/JadeFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/plugins/jade/JadeFileViewProvider", "<init>"));
        }
        super(manager, virtualFile, physical);
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "com/jetbrains/plugins/jade/JadeFileViewProvider", "supportsIncrementalReparse"));
        }
        return false;
    }

    @NotNull
    public Language getBaseLanguage() {
        JadeLanguage jadeLanguage = JadeLanguage.INSTANCE;
        if (jadeLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeFileViewProvider", "getBaseLanguage"));
        }
        return jadeLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = LANGUAGES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeFileViewProvider", "getLanguages"));
        }
        return set;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/jetbrains/plugins/jade/JadeFileViewProvider", "createFile"));
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        return null;
    }
}

