/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JadeToPugTransitionHelper {
    @NotNull
    public static final List<String> ALL_EXTENSIONS = Arrays.asList("jade", "pug");

    static String trimAnyExtension(@NotNull String given, @NotNull List<String> ends) {
        if (given == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "given", "com/jetbrains/plugins/jade/JadeToPugTransitionHelper", "trimAnyExtension"));
        }
        if (ends == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ends", "com/jetbrains/plugins/jade/JadeToPugTransitionHelper", "trimAnyExtension"));
        }
        for (String end : ends) {
            if (!given.endsWith("." + end)) continue;
            return given.substring(0, given.length() - end.length() - 1);
        }
        return given;
    }

    @NotNull
    public static String getExtension(PsiFile file) {
        String extension = FileUtilRt.getExtension((String)file.getName());
        if (file instanceof JadeFileImpl && !extension.isEmpty()) {
            String string = extension;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeToPugTransitionHelper", "getExtension"));
            }
            return string;
        }
        if ("jade" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/JadeToPugTransitionHelper", "getExtension"));
        }
        return "jade";
    }

    public static boolean isPugElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/jade/JadeToPugTransitionHelper", "isPugElement"));
        }
        if (!element.isValid()) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        return FileUtilRt.extensionEquals((String)file.getName(), (String)"pug");
    }
}

