/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.formatter;

import com.intellij.embedding.TemplateMasqueradingLexer;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.formatter.JadeCommentBlock;
import com.jetbrains.plugins.jade.lexer.IndentUtil;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddedTokenTypesWrapper;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddedTokenTypesWrapperForCssStylesheet;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import com.jetbrains.plugins.jade.psi.impl.JadeBlockImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeCaseStatementImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeCommentImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeConditionalElseImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeConditionalStatementImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeFilterImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeForStatementImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeIncludeStatementImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeJSCodeLineImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeJSStatementImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeTagImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeWhenStatementImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeBlock
extends TemplateLanguageBlock {
    private static final EmbeddedTokenTypesProvider[] ourEmbeddedTokenTypesProviders = (EmbeddedTokenTypesProvider[])Extensions.getExtensions((ExtensionPointName)EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME);
    private static final Set<String> ourTagNamesWithChildIndentByEnter = ContainerUtil.immutableSet((Object[])new String[]{"div", "ol", "ul", "script", "style", "body", "head", "table", "tbody", "form", "block", "html"});
    @NotNull
    private final TemplateLanguageBlockFactory myBlockFactory;
    @NotNull
    private final CodeStyleSettings mySettings;
    private final Indent myIndent;

    protected JadeBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren, Indent indent) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/plugins/jade/formatter/JadeBlock", "<init>"));
        }
        if (blockFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockFactory", "com/jetbrains/plugins/jade/formatter/JadeBlock", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/jade/formatter/JadeBlock", "<init>"));
        }
        super(node, wrap, alignment, blockFactory, settings, foreignChildren);
        this.myBlockFactory = blockFactory;
        this.mySettings = settings;
        this.myIndent = indent;
    }

    protected IElementType getTemplateTextElementType() {
        return JadeTokenTypes.JS_CODE_BLOCK;
    }

    protected List<Block> buildChildren() {
        if (JadeTokenTypes.COMMENTS.contains(this.myNode.getElementType()) || this.myNode.getElementType() == JadeTokenTypes.TEXT) {
            return this.buildTextChildrenBlocks();
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            Block blockForAChild = this.getBlockForAChild(child);
            if (blockForAChild == null) continue;
            result.add(blockForAChild);
        }
        return result;
    }

    @Nullable
    private Block getBlockForAChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getBlockForAChild"));
        }
        if (AbstractXmlBlock.containsWhiteSpacesOnly((ASTNode)child) || child.getTextLength() <= 0) {
            return null;
        }
        IElementType childType = child.getElementType();
        Language injectedLang = JadeBlock.getInjectedLanguageForElementType(childType);
        if (injectedLang != null) {
            FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext(injectedLang, child.getPsi());
            if (builder != null) {
                FormattingModel childModel = builder.createModel(child.getPsi(), this.getSettings());
                return new InjectedLanguageBlockWrapper(childModel.getRootBlock(), 0, null, this.getIndentForChildScript());
            }
            return new JadeBlock(child, null, null, this.myBlockFactory, this.mySettings, null, Indent.getNormalIndent());
        }
        Indent childIndent = JadeBlock.shouldIndentChildren(this.myNode) && (childType == JadeElementTypes.TAG || childType == JadeElementTypes.MIXIN || childType == JadeElementTypes.MIXIN_DECLARATION || childType == JadeElementTypes.CASE_STATEMENT || childType == JadeElementTypes.CONDITIONAL_STATEMENT || childType == JadeElementTypes.CONDITIONAL_BODY || childType == JadeElementTypes.FOR_STATEMENT || childType == JadeElementTypes.FOR_BODY || childType == JadeElementTypes.WHEN_STATEMENT || childType == JadeElementTypes.FILTER || childType == JadeElementTypes.INCLUDE_STATEMENT || childType == JadeElementTypes.JS_CODE_BLOCK_PATCHED || childType == JadeElementTypes.JS_CODE_BLOCK || childType == JadeElementTypes.JS_EXPR || childType == JadeElementTypes.BLOCK || childType == JadeElementTypes.YIELD_STATEMENT || childType == JadeElementTypes.PIPED_TEXT || childType == JadeTokenTypes.FILTER_CODE || childType == JadeTokenTypes.JS_META_CODE || childType == JadeTokenTypes.TEXT || childType instanceof JadeEmbeddedTokenTypesWrapper || child instanceof JadeCommentImpl || JadeBlock.isJsCodeBlock(this.myNode, child)) ? Indent.getNormalIndent() : Indent.getNoneIndent();
        return new JadeBlock(child, null, null, this.myBlockFactory, this.mySettings, null, childIndent);
    }

    private List<Block> buildTextChildrenBlocks() {
        ArrayList<Block> result = new ArrayList<Block>();
        CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getCommonSettings((Language)JadeLanguage.INSTANCE).getIndentOptions();
        int blockIndent = JadeBlock.calcCurrentAbsoluteIndent(this.myNode, indentOptions.TAB_SIZE);
        String text = this.myNode.getText();
        int lineStart = 0;
        while (lineStart < text.length()) {
            char c;
            int nonWs = lineStart;
            while ((c = text.charAt(nonWs)) != '\n' && Character.isWhitespace(c) && ++nonWs != text.length()) {
            }
            if (c != '\n') {
                int blockEnd;
                int currentIndentInSpaces = IndentUtil.calcIndent(text.substring(lineStart, nonWs), 0, indentOptions.TAB_SIZE);
                int eol = text.indexOf(10, nonWs);
                int n = blockEnd = eol != -1 ? eol : text.length();
                if (blockEnd > nonWs) {
                    result.add(new JadeCommentBlock(this.myNode, nonWs, blockEnd, JadeBlock.calcIndentForSpaces(currentIndentInSpaces - blockIndent, indentOptions)));
                }
                if (eol == -1) break;
                lineStart = eol + 1;
                continue;
            }
            lineStart = nonWs + 1;
        }
        return result;
    }

    private static int calcCurrentAbsoluteIndent(ASTNode node, int tabSize) {
        int wsStart;
        int wsEnd;
        int startOffset = node.getStartOffset();
        String text = TreeUtil.getFileElement((TreeElement)((TreeElement)node)).getText();
        for (wsEnd = startOffset; wsEnd > 0 && !Character.isWhitespace(text.charAt(wsEnd)); --wsEnd) {
        }
        for (wsStart = wsEnd; wsStart > 0 && Character.isWhitespace(text.charAt(wsEnd)) && text.charAt(wsStart) != '\n'; --wsStart) {
        }
        return wsEnd > wsStart ? IndentUtil.calcIndent(text.substring(wsStart, wsEnd + 1), 0, tabSize) : 0;
    }

    private static boolean shouldIndentChildren(ASTNode node) {
        return node instanceof JadeTagImpl || node instanceof JadeConditionalStatementImpl || node instanceof JadeForStatementImpl || node instanceof JadeFilterImpl || node instanceof JadeIncludeStatementImpl || node instanceof JadeConditionalElseImpl || node.getElementType() == JadeElementTypes.MIXIN_DECLARATION || node instanceof JadeCaseStatementImpl || node instanceof JadeWhenStatementImpl || node instanceof JadeJSCodeLineImpl || node instanceof JadeJSStatementImpl && ((JadeJSStatementImpl)node).hasJadeBlock() || node.getElementType() == JadeTokenTypes.JS_META_CODE;
    }

    private static boolean shouldIndentChildrenAfterEnter(ASTNode node) {
        if (!JadeBlock.shouldIndentChildren(node)) {
            return false;
        }
        if (node instanceof JadeIncludeStatementImpl) {
            return ((JadeIncludeStatementImpl)node).getFirstChildNode().getElementType() == JadeTokenTypes.INCLUDE_KEYWORD;
        }
        if (node instanceof JadeTagImpl) {
            String name = ((JadeTagImpl)node).getName();
            return ourTagNamesWithChildIndentByEnter.contains(name);
        }
        return true;
    }

    private static Indent calcIndentForSpaces(int spaces, CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (spaces <= 0) {
            return Indent.getNoneIndent();
        }
        if (indentOptions.USE_TAB_CHARACTER) {
            spaces = Math.round((float)spaces / (float)indentOptions.TAB_SIZE) * indentOptions.TAB_SIZE;
        }
        return Indent.getSpaceIndent((int)spaces, (boolean)false);
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getSpacing"));
        }
        return this.createSpacingBuilder().getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block block = this.getPrevChildBlock(newChildIndex);
        if (block instanceof AbstractBlock) {
            ASTNode prevChild = ((AbstractBlock)block).getNode();
            if (JadeBlock.shouldIndentChildren(prevChild) || prevChild instanceof JadeCommentImpl) {
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
        } else if (block instanceof InjectedLanguageBlockWrapper && (this.myNode instanceof JadeBlockImpl || ((InjectedLanguageBlockWrapper)block).getLanguage() == CSSLanguage.INSTANCE)) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    private Block getPrevChildBlock(int newChildIndex) {
        if (newChildIndex == 0) {
            return null;
        }
        return (Block)this.getSubBlocks().get(newChildIndex - 1);
    }

    @Nullable
    protected Indent getChildIndent() {
        return JadeBlock.shouldIndentChildren(this.myNode) && JadeBlock.shouldIndentChildrenAfterEnter(this.myNode) || this.myNode instanceof JadeCommentImpl ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    private SpacingBuilder createSpacingBuilder() {
        return new SpacingBuilder(this.getSettings(), (Language)JadeLanguage.INSTANCE).between(JadeTokenTypes.PIPE, JadeTokenTypes.TEXT).spacing(1, Integer.MAX_VALUE, 0, false, 0);
    }

    @Nullable
    private static Language getInjectedLanguageForElementType(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getInjectedLanguageForElementType"));
        }
        if (elementType instanceof JadeEmbeddedTokenTypesWrapper) {
            return JadeBlock.getInjectedLanguageForElementType(((JadeEmbeddedTokenTypesWrapper)elementType).getDelegate());
        }
        if (elementType instanceof JadeEmbeddedTokenTypesWrapperForCssStylesheet) {
            return elementType.getLanguage();
        }
        if (elementType == JadeTokenTypes.STYLE_BLOCK) {
            return CSSLanguage.INSTANCE;
        }
        if (elementType == JadeTokenTypes.JS_CODE_BLOCK || elementType == JadeTokenTypes.JS_EXPR) {
            return JavascriptLanguage.INSTANCE;
        }
        if (elementType == JadeTokenTypes.JS_CODE_BLOCK_PATCHED) {
            return null;
        }
        for (EmbeddedTokenTypesProvider provider : ourEmbeddedTokenTypesProviders) {
            if (provider.getElementType() != elementType) continue;
            return provider.getElementType().getLanguage();
        }
        return null;
    }

    @NotNull
    private Indent getIndentForChildScript() {
        if (!(this.myNode instanceof JadeTagImpl)) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getIndentForChildScript"));
            }
            return indent;
        }
        PsiElement firstChild = ((JadeTagImpl)this.myNode).getFirstChild();
        if (!(firstChild instanceof XmlTokenImpl)) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getIndentForChildScript"));
            }
            return indent;
        }
        String name = firstChild.getText();
        if ("script".equals(name) || "style".equals(name)) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getIndentForChildScript"));
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeBlock", "getIndentForChildScript"));
        }
        return indent;
    }

    private static boolean isJsCodeBlock(@NotNull ASTNode parent, @NotNull ASTNode child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/plugins/jade/formatter/JadeBlock", "isJsCodeBlock"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/plugins/jade/formatter/JadeBlock", "isJsCodeBlock"));
        }
        if (parent.getElementType() != JadeTokenTypes.JS_META_CODE) {
            return false;
        }
        if (!(child.getPsi() instanceof JSElement)) {
            return false;
        }
        ASTNode minus = parent.findChildByType(TemplateMasqueradingLexer.MINUS_TYPE);
        if (minus == null) {
            return false;
        }
        ASTNode next = minus.getTreeNext();
        return next != null && next.getElementType() == JadeTokenTypes.INDENT;
    }
}

