/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeCommentBlock
implements Block {
    private static final List<Block> EMPTY_BLOCK_LIST = new ArrayList<Block>();
    private final ASTNode myNode;
    private final int myStartOffset;
    private final int myEndOffset;
    private final Indent myIndent;

    public JadeCommentBlock(ASTNode node, int startOffset, int endOffset, Indent indent) {
        this.myNode = node;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myIndent = indent;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = new TextRange(this.myNode.getStartOffset() + this.myStartOffset, this.myNode.getStartOffset() + this.myEndOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeCommentBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = EMPTY_BLOCK_LIST;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeCommentBlock", "getSubBlocks"));
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/plugins/jade/formatter/JadeCommentBlock", "getSpacing"));
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/formatter/JadeCommentBlock", "getChildAttributes"));
        }
        return null;
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }
}

