/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.highlighter;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.highlighter.JadeHighlighter;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddingUtil;
import com.jetbrains.plugins.jade.lexer.JadeHighlightingLexer;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JadeSyntaxHighlighter
extends SyntaxHighlighterBase
implements SyntaxHighlighter {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private final CodeStyleSettings myCodeStyleSettings;
    private static final Map<Language, SyntaxHighlighter> ourEmbeddedLanguageToHighlighterMap = ContainerUtil.newConcurrentMap();

    public JadeSyntaxHighlighter(CodeStyleSettings codeStyleSettings) {
        this.myCodeStyleSettings = codeStyleSettings;
    }

    private static void put(IElementType token, TextAttributesKey value) {
        if (ATTRIBUTES.put(token, value) != null) {
            Logger.getInstance(JadeSyntaxHighlighter.class).error("ALREADY MAPPED: " + token);
        }
    }

    private static void put(TokenSet tokens, TextAttributesKey value) {
        for (IElementType type : tokens.getTypes()) {
            JadeSyntaxHighlighter.put(type, value);
        }
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        JadeHighlightingLexer jadeHighlightingLexer = new JadeHighlightingLexer(this.myCodeStyleSettings);
        if (jadeHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/highlighter/JadeSyntaxHighlighter", "getHighlightingLexer"));
        }
        return jadeHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey ownResult = ATTRIBUTES.get(tokenType);
        if (tokenType.getLanguage() == JadeLanguage.INSTANCE || ownResult != null) {
            TextAttributesKey[] textAttributesKeyArray = JadeSyntaxHighlighter.pack((TextAttributesKey)ownResult);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/highlighter/JadeSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = JadeSyntaxHighlighter.getHighlighterForLanguage(tokenType.getLanguage()).getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/highlighter/JadeSyntaxHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    @NotNull
    private static SyntaxHighlighter getHighlighterForLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/jetbrains/plugins/jade/highlighter/JadeSyntaxHighlighter", "getHighlighterForLanguage"));
        }
        SyntaxHighlighter result = ourEmbeddedLanguageToHighlighterMap.get(language);
        if (result == null) {
            result = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, null, null);
            ourEmbeddedLanguageToHighlighterMap.put(language, result);
        }
        SyntaxHighlighter syntaxHighlighter = result;
        if (syntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/highlighter/JadeSyntaxHighlighter", "getHighlighterForLanguage"));
        }
        return syntaxHighlighter;
    }

    static {
        JadeSyntaxHighlighter.put(JadeTokenTypes.COMMENT, JadeHighlighter.COMMENT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.UNBUF_COMMENT, JadeHighlighter.UNBUF_COMMENT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.DOCTYPE_KEYWORD, JadeHighlighter.DOCTYPE_KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TEXT, JadeHighlighter.TEXT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.STRING_LITERAL, JadeHighlighter.TEXT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.CHAR_LITERAL, JadeHighlighter.TEXT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TAG_NAME, JadeHighlighter.TAG_NAME);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ATTRIBUTE_NAME, JadeHighlighter.ATTRIBUTE_NAME);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ATTRIBUTES_KEYWORD, JadeHighlighter.ATTRIBUTE_NAME);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TAG_ID, JadeHighlighter.TAG_ID);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TAG_CLASS, JadeHighlighter.TAG_CLASS);
        JadeSyntaxHighlighter.put(JadeTokenTypes.BAD_CHARACTER, JadeHighlighter.BAD_CHARACTER);
        JadeSyntaxHighlighter.put(JadeTokenTypes.NUMBER, JadeHighlighter.NUMBER);
        JadeSyntaxHighlighter.put(JadeTokenTypes.PIPE, JadeHighlighter.PIPE);
        JadeSyntaxHighlighter.put(JadeTokenTypes.COMMA, JadeHighlighter.COMMA);
        JadeSyntaxHighlighter.put(JadeTokenTypes.LPAREN, JadeHighlighter.PARENTS);
        JadeSyntaxHighlighter.put(JadeTokenTypes.RPAREN, JadeHighlighter.PARENTS);
        JadeSyntaxHighlighter.put(JadeTokenTypes.COLON, JadeHighlighter.COLON);
        JadeSyntaxHighlighter.put(JadeTokenTypes.MINUS, JadeHighlighter.OPERATION_SIGN);
        JadeSyntaxHighlighter.put(JadeTokenTypes.EQ, JadeHighlighter.OPERATION_SIGN);
        JadeSyntaxHighlighter.put(JadeTokenTypes.NEQ, JadeHighlighter.OPERATION_SIGN);
        JadeSyntaxHighlighter.put(JadeTokenTypes.COND_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ELSE_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ITERATION_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.CASE, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.WHEN, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.DEFAULT_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.EXTENDS_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.FILE_PATH, JadeHighlighter.FILE_PATH);
        JadeSyntaxHighlighter.put(JadeTokenTypes.INCLUDE_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.YIELD_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.MIXIN_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.FILTER_NAME, JadeHighlighter.FILTER_NAME);
        JadeSyntaxHighlighter.put(JadeEmbeddingUtil.getAllEmbeddedWrapperTypes(), JadeHighlighter.EMBEDDED_CONTENT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.JS_TOKENS, JadeHighlighter.JS_BLOCK);
        HtmlFileHighlighter.registerEmbeddedTokenAttributes(ATTRIBUTES, null);
        XmlFileHighlighter.registerEmbeddedTokenAttributes(ATTRIBUTES, null);
    }
}

