/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.js;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSForInStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSEachStatementImpl
extends JSForInStatementImpl {
    public JSEachStatementImpl(ASTNode node) {
        super(node);
    }

    public JSVarStatement getDeclarationStatement() {
        JSVarStatement[] allDeclarationStatements = this.getAllDeclarationStatements();
        if (allDeclarationStatements.length >= 2) {
            return allDeclarationStatements[1];
        }
        return null;
    }

    public JSStatement getBody() {
        JSExpression collectionExpression = this.getCollectionExpression();
        if (collectionExpression == null) {
            return null;
        }
        ASTNode next = collectionExpression.getNode().getTreeNext();
        if (next != null && JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(next.getElementType())) {
            return (JSStatement)next.getPsi();
        }
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/plugins/jade/js/JSEachStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/plugins/jade/js/JSEachStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/plugins/jade/js/JSEachStatementImpl", "processDeclarations"));
        }
        if (lastParent != null) {
            JSVarStatement[] varStatements;
            for (JSVarStatement varStatement : varStatements = this.getAllDeclarationStatements()) {
                varStatement.processDeclarations(processor, state, lastParent, place);
            }
        }
        return true;
    }

    private JSVarStatement[] getAllDeclarationStatements() {
        ArrayList<JSVarStatement> varStatements = new ArrayList<JSVarStatement>(2);
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSElementTypes.VAR_STATEMENT) {
                varStatements.add((JSVarStatement)child.getPsi());
                continue;
            }
            if (child.getElementType() == JSTokenTypes.IN_KEYWORD) break;
        }
        return (JSVarStatement[])ContainerUtil.toArray(varStatements, (Object[])new JSVarStatement[varStatements.size()]);
    }
}

