/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.lexer;

import com.intellij.embedding.EmbeddedLazyParseableElementType;
import com.intellij.embedding.MasqueradingLexer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashSet;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JadeBaseInterpolationLexer
extends MasqueradingLexer.SmartDelegate {
    private CharSequence myBuffer;
    private int myStartOffset;
    private Set<TextRange> myInterpolations;

    public JadeBaseInterpolationLexer(@NotNull Lexer delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "<init>"));
        }
        super(delegate);
    }

    protected abstract CharSequence getSubstitutionForInterpolation(CharSequence var1, int var2, int var3, TextRange var4);

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        List<TextRange> interpolations = JadeBaseInterpolationLexer.findAllInterpolations(buffer, startOffset, endOffset);
        if (interpolations.isEmpty()) {
            this.myInterpolations = Collections.emptySet();
            super.start(buffer.subSequence(startOffset, endOffset), 0, endOffset - startOffset, initialState);
            return;
        }
        this.myInterpolations = new HashSet(interpolations);
        CharSequence newBuffer = this.substituteInterpolations(buffer, startOffset, endOffset, interpolations);
        super.start(newBuffer, 0, newBuffer.length(), initialState);
    }

    @Nullable
    public IElementType getTokenType() {
        TextRange tokenRange = this.getTokenRange();
        for (TextRange interpolation : this.myInterpolations) {
            if (!tokenRange.contains(interpolation)) continue;
            return InterpolationType.getInstance(super.getTokenType());
        }
        return super.getTokenType();
    }

    @NotNull
    public String getTokenText() {
        TextRange tokenRange = this.getTokenRange();
        String string = this.myBuffer.subSequence(tokenRange.getStartOffset(), tokenRange.getEndOffset()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "getTokenText"));
        }
        return string;
    }

    private TextRange getTokenRange() {
        return TextRange.create((int)this.getTokenStart(), (int)this.getTokenEnd()).shiftRight(this.myStartOffset);
    }

    private CharSequence substituteInterpolations(@NotNull CharSequence buffer, int start, int end, @NotNull List<TextRange> interpolations) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "substituteInterpolations"));
        }
        if (interpolations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpolations", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "substituteInterpolations"));
        }
        assert (!interpolations.isEmpty());
        int startPos = start;
        StringBuilder sb = new StringBuilder();
        for (TextRange interpolation : interpolations) {
            sb.append(buffer.subSequence(startPos, interpolation.getStartOffset()));
            sb.append(this.getSubstitutionForInterpolation(buffer, start, end, interpolation));
            startPos = interpolation.getEndOffset();
        }
        sb.append(buffer.subSequence(startPos, end));
        return sb.toString();
    }

    private static List<TextRange> findAllInterpolations(@NotNull CharSequence buffer, int start, int end) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "findAllInterpolations"));
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        while (start < end && (start = JadeBaseInterpolationLexer.findInterpolationStartPos(buffer, start, end)) < end) {
            int endOfInterpolation = JadeBaseInterpolationLexer.findClosingBraceWithRespectToOpeningOnes(buffer, start + 2, end);
            if (endOfInterpolation < end) {
                result.add(new TextRange(start, endOfInterpolation + 1));
            }
            start = endOfInterpolation + 1;
        }
        return result;
    }

    private static int findInterpolationStartPos(@NotNull CharSequence buffer, int start, int end) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "findInterpolationStartPos"));
        }
        int i = start;
        while (i + 2 < end) {
            if (!(buffer.charAt(i) != '#' && buffer.charAt(i) != '!' || buffer.charAt(i + 1) != '{' || i != start && buffer.charAt(i - 1) == '\\')) {
                return i;
            }
            ++i;
        }
        return end;
    }

    private static int findClosingBraceWithRespectToOpeningOnes(@NotNull CharSequence buffer, int startPos, int end) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer", "findClosingBraceWithRespectToOpeningOnes"));
        }
        int balance = 1;
        int pos = startPos;
        while (balance > 0 && pos < end) {
            char c;
            if ((c = buffer.charAt(pos++)) == '{') {
                ++balance;
                continue;
            }
            if (c != '}') continue;
            --balance;
        }
        if (balance == 0) {
            return pos - 1;
        }
        return end;
    }

    private static class InterpolationType
    extends EmbeddedLazyParseableElementType {
        private static final Map<IElementType, InterpolationType> INSTANCES = new HashMap<IElementType, InterpolationType>();
        @Nullable
        private final IElementType myType;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InterpolationType getInstance(@Nullable IElementType flankingType) {
            if (INSTANCES.containsKey(flankingType)) {
                return INSTANCES.get(flankingType);
            }
            Map<IElementType, InterpolationType> map = INSTANCES;
            synchronized (map) {
                if (!INSTANCES.containsKey(flankingType)) {
                    INSTANCES.put(flankingType, new InterpolationType(flankingType));
                }
            }
            return INSTANCES.get(flankingType);
        }

        private InterpolationType(@Nullable IElementType flankingType) {
            super("INTERPOLATION", (Language)JadeLanguage.INSTANCE);
            this.myType = flankingType;
        }

        public Lexer createLexer(@NotNull ASTNode chameleon, @NotNull Project project, @NotNull Language parentLanguage) {
            if (chameleon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType", "createLexer"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType", "createLexer"));
            }
            if (parentLanguage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLanguage", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType", "createLexer"));
            }
            return new MyLexer(this.myType);
        }

        public ASTNode parseAndGetTree(@NotNull PsiBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType", "parseAndGetTree"));
            }
            PsiBuilder.Marker marker = builder.mark();
            while (!builder.eof()) {
                builder.advanceLexer();
            }
            marker.done((IElementType)this);
            return builder.getTreeBuilt();
        }

        private static class MyLexer
        extends LexerBase {
            private final IElementType myType;
            private int myLeft;
            private int myRight;
            private CharSequence myBuffer;
            private int myStartOffset;
            private int myEndOffset;
            private int myState;

            public MyLexer(IElementType type) {
                this.myType = type;
            }

            public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
                if (buffer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType$MyLexer", "start"));
                }
                this.myBuffer = buffer;
                this.myStartOffset = startOffset;
                this.myEndOffset = endOffset;
                this.myState = initialState;
                boolean foundFirstInterpolation = this.findInterpolationAndInitLeftAndRight(this.myStartOffset);
                assert (foundFirstInterpolation) : "could not be invoked w/o interpolation";
                this.adjustState();
            }

            private boolean findInterpolationAndInitLeftAndRight(int from) {
                int start = JadeBaseInterpolationLexer.findInterpolationStartPos(this.myBuffer, from, this.myEndOffset);
                if (start >= this.myEndOffset) {
                    return false;
                }
                int end = JadeBaseInterpolationLexer.findClosingBraceWithRespectToOpeningOnes(this.myBuffer, start + 2, this.myEndOffset);
                if (end >= this.myEndOffset) {
                    return false;
                }
                this.myLeft = start - this.myStartOffset;
                this.myRight = this.myEndOffset - end - 1;
                return true;
            }

            public int getState() {
                return this.myState;
            }

            @Nullable
            public IElementType getTokenType() {
                switch (this.myState) {
                    case 0: {
                        return this.myType;
                    }
                    case 1: 
                    case 3: {
                        return JadeTokenTypes.TEXT;
                    }
                    case 2: {
                        return JadeTokenTypes.JS_EXPR;
                    }
                    case 4: {
                        return this.myType;
                    }
                }
                return null;
            }

            public int getTokenStart() {
                switch (this.myState) {
                    case 0: {
                        return this.myStartOffset;
                    }
                    case 1: {
                        return this.myStartOffset + this.myLeft;
                    }
                    case 2: {
                        return this.myStartOffset + this.myLeft + 2;
                    }
                    case 3: {
                        return this.myEndOffset - this.myRight - 1;
                    }
                    case 4: {
                        return this.myEndOffset - this.myRight;
                    }
                }
                return this.myEndOffset;
            }

            public int getTokenEnd() {
                switch (this.myState) {
                    case 0: {
                        return this.myStartOffset + this.myLeft;
                    }
                    case 1: {
                        return this.myStartOffset + this.myLeft + 2;
                    }
                    case 2: {
                        return this.myEndOffset - this.myRight - 1;
                    }
                    case 3: {
                        return this.myEndOffset - this.myRight;
                    }
                    case 4: {
                        return this.myEndOffset;
                    }
                }
                return this.myEndOffset;
            }

            public void advance() {
                ++this.myState;
                if (this.myState == 4) {
                    this.myStartOffset = this.myEndOffset - this.myRight;
                    boolean foundNextInterpolation = this.findInterpolationAndInitLeftAndRight(this.myStartOffset);
                    if (foundNextInterpolation) {
                        this.myState = 0;
                    }
                }
                this.adjustState();
            }

            private void adjustState() {
                if (this.myState == 0 && this.myLeft == 0 || this.myState == 4 && this.myRight == 0) {
                    ++this.myState;
                }
            }

            @NotNull
            public CharSequence getBufferSequence() {
                CharSequence charSequence = this.myBuffer;
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType$MyLexer", "getBufferSequence"));
                }
                return charSequence;
            }

            public int getBufferEnd() {
                return this.myEndOffset;
            }
        }
    }
}

