/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.lexer;

import com.intellij.lang.Language;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.lexer._JadeLexer;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;

class JadeBaseLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{JadeTokenTypes.COMMENT, JadeTokenTypes.UNBUF_COMMENT, JadeTokenTypes.EOL, JadeTokenTypes.TEXT, JadeTokenTypes.ATTRIBUTE_VALUE, JadeTokenTypes.IDENTIFIER, JadeTokenTypes.JS_CODE_BLOCK, JadeTokenTypes.JS_EXPR, JadeTokenTypes.JS_EACH_EXPR, JadeTokenTypes.STYLE_BLOCK, JadeTokenTypes.FILE_PATH, JadeTokenTypes.JS_CODE_BLOCK_PATCHED, JadeTokenTypes.FILTER_CODE, JadeTokenTypes.JS_MIXIN_PARAMS, JadeTokenTypes.JS_META_CODE});
    public static final MergeFunction MERGE_FUNCTION = new MergeFunction(){

        public IElementType merge(IElementType type, Lexer originalLexer) {
            IElementType tokenType;
            if (type != JadeTokenTypes.EOL) {
                return type;
            }
            if (originalLexer.getTokenType() != JadeTokenTypes.INDENT) {
                return JadeTokenTypes.EOL;
            }
            while ((tokenType = originalLexer.getTokenType()) == JadeTokenTypes.INDENT) {
                originalLexer.advance();
            }
            return JadeTokenTypes.INDENT;
        }
    };

    public JadeBaseLexer(CodeStyleSettings codeStyleSettings, int explicitTabSize) {
        super((Lexer)new MergingLexerAdapter((Lexer)JadeBaseLexer.getFlexAdapter(codeStyleSettings, explicitTabSize), null){

            public MergeFunction getMergeFunction() {
                return MERGE_FUNCTION;
            }
        }, TOKENS_TO_MERGE);
    }

    private static FlexAdapter getFlexAdapter(final CodeStyleSettings codeStyleSettings, final int explicitTabSize) {
        return new FlexAdapter((FlexLexer)new _JadeLexer(null){
            {
                super(in);
                this.resetInternal(this.getTabSize());
            }

            @Override
            public void reset(CharSequence buffer, int start, int end, int initialState) {
                super.reset(buffer, start, end, initialState);
                this.resetInternal(this.getTabSize());
            }

            private int getTabSize() {
                CommonCodeStyleSettings.IndentOptions options;
                CommonCodeStyleSettings settings;
                if (explicitTabSize > 0) {
                    return explicitTabSize;
                }
                if (codeStyleSettings != null && (settings = codeStyleSettings.getCommonSettings((Language)JadeLanguage.INSTANCE)) != null && (options = settings.getIndentOptions()) != null) {
                    return options.TAB_SIZE;
                }
                return 2;
            }
        });
    }
}

