/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.plugins.jade.psi.impl.JadeAttributeValueImpl;
import org.jetbrains.annotations.NotNull;

public class JadeAttributeValueManipulator
extends AbstractElementManipulator<JadeAttributeValueImpl> {
    public JadeAttributeValueImpl handleContentChange(@NotNull JadeAttributeValueImpl attrValue, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (attrValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrValue", "com/jetbrains/plugins/jade/psi/impl/JadeAttributeValueManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/plugins/jade/psi/impl/JadeAttributeValueManipulator", "handleContentChange"));
        }
        if (!attrValue.isSyntheticValue()) {
            return JadeAttributeValueManipulator.handleContentChangeAttr(attrValue, range, newContent);
        }
        JadeAttributeValueManipulator.handleContentChangeSynthetic(attrValue, range, newContent);
        return attrValue;
    }

    private static JadeAttributeValueImpl handleContentChangeAttr(JadeAttributeValueImpl value, TextRange range, String content) {
        String oldText = value.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + content + oldText.substring(range.getEndOffset());
        if (newText.isEmpty()) {
            return null;
        }
        String s = "dummy(a=" + newText + ")";
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)value.getProject()).createFileFromText((CharSequence)s, value.getContainingFile());
        if (dummyFile == null) {
            return null;
        }
        PsiElement leafElement = dummyFile.findElementAt("dummy(a=".length());
        JadeAttributeValueImpl replacement = (JadeAttributeValueImpl)PsiTreeUtil.getParentOfType((PsiElement)leafElement, JadeAttributeValueImpl.class);
        if (replacement == null) {
            return null;
        }
        return (JadeAttributeValueImpl)value.replace((PsiElement)replacement);
    }

    public static void handleContentChangeSynthetic(JadeAttributeValueImpl attrValue, TextRange range, String newContent) {
        JadeAttributeValueImpl element = attrValue;
        while (!(element instanceof LeafPsiElement)) {
            element = element.getLastChild();
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        int deltaOffset = attrValue.getStartOffset() - ((LeafPsiElement)element).getStartOffset();
        manipulator.handleContentChange((PsiElement)element, range.shiftRight(deltaOffset), newContent);
    }
}

