/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.impl.JadeAttributeImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeAttributeValueImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeFakeXmlNameElement;
import org.jetbrains.annotations.NotNull;

public class JadeTagImpl
extends XmlTagImpl
implements HtmlTag {
    public static final String DIV = "div";

    public JadeTagImpl() {
        super(JadeElementTypes.TAG);
    }

    public JadeTagImpl(IElementType type) {
        super(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.getElementType().toString() + ")";
    }

    @NotNull
    public String getName() {
        PsiElement child = this.getFirstChild();
        if (child != null && child.getNode().getElementType() == XmlTokenType.XML_TAG_NAME) {
            String string = child.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/psi/impl/JadeTagImpl", "getName"));
            }
            return string;
        }
        if (DIV == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/psi/impl/JadeTagImpl", "getName"));
        }
        return DIV;
    }

    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)this);
        XmlAttribute[] attributes = this.getAttributes();
        CharSequence charTableIndex = charTableByTree.intern((CharSequence)qname);
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            CharSequence name;
            ASTNode attrNameElement = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            CharSequence charSequence = attrNameElement instanceof JadeFakeXmlNameElement ? charTableByTree.intern((CharSequence)attribute.getLocalName()) : (name = attrNameElement != null ? attrNameElement.getChars() : null);
            if (name == null || (!caseSensitive || !name.equals(charTableIndex)) && (caseSensitive || !Comparing.equal((CharSequence)name, (CharSequence)charTableIndex, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    public String getAttributeValue(String qname) {
        JadeAttributeImpl[] attributes;
        if ("class".equals(qname) && (attributes = (JadeAttributeImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)this, JadeAttributeImpl.class)) != null && attributes.length > 0) {
            StringBuilder s = new StringBuilder();
            for (JadeAttributeImpl attribute : attributes) {
                JadeAttributeValueImpl valueElement = attribute.getValueElement();
                if (valueElement == null || !"class".equalsIgnoreCase(attribute.getName()) && !valueElement.isSyntheticClass()) continue;
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(valueElement.getValue());
            }
            return s.toString();
        }
        return super.getAttributeValue(qname);
    }

    @NotNull
    public Language getLanguage() {
        JadeLanguage jadeLanguage = JadeLanguage.INSTANCE;
        if (jadeLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/psi/impl/JadeTagImpl", "getLanguage"));
        }
        return jadeLanguage;
    }
}

