/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.psi.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssReferenceContributor;
import com.intellij.psi.css.impl.util.CssInHtmlClassOrIdReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.util.XmlUtil;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeAttributeValueImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JadeCssReferenceContributor
extends CssReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/plugins/jade/psi/references/JadeCssReferenceContributor", "registerReferenceProviders"));
        }
        CssInJadeClassOrIdReferenceProvider htmlClassOrIdReferenceProvider = new CssInJadeClassOrIdReferenceProvider();
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"class", "id"}, (ElementFilter)htmlClassOrIdReferenceProvider.getFilter(), (boolean)false, (PsiReferenceProvider)htmlClassOrIdReferenceProvider);
    }

    private static class CssInJadeClassOrIdReferenceProvider
    extends CssInHtmlClassOrIdReferenceProvider {
        private CssInJadeClassOrIdReferenceProvider() {
        }

        public ElementFilter getFilter() {
            return new CssInJadeElementFilter();
        }

        protected void doExtractReferences(@NotNull String text, @NotNull PsiElement element, @NotNull List<PsiReference> references, int offset) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/plugins/jade/psi/references/JadeCssReferenceContributor$CssInJadeClassOrIdReferenceProvider", "doExtractReferences"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/jade/psi/references/JadeCssReferenceContributor$CssInJadeClassOrIdReferenceProvider", "doExtractReferences"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/jetbrains/plugins/jade/psi/references/JadeCssReferenceContributor$CssInJadeClassOrIdReferenceProvider", "doExtractReferences"));
            }
            if (element instanceof JadeAttributeValueImpl && ((JadeAttributeValueImpl)element).isSyntheticValue()) {
                super.doExtractReferences(text.substring(1), element, references, 1);
            } else {
                super.doExtractReferences(text, element, references, offset);
            }
        }

        private static class CssInJadeElementFilter
        implements ElementFilter {
            private CssInJadeElementFilter() {
            }

            public boolean isAcceptable(Object element, PsiElement context) {
                PsiElement psiElement = (PsiElement)element;
                if (!(psiElement.getContainingFile() instanceof JadeFileImpl)) {
                    return false;
                }
                PsiElement parent = psiElement.getParent();
                if (parent instanceof XmlAttribute) {
                    XmlAttribute xmlAttribute = (XmlAttribute)parent;
                    String attrName = xmlAttribute.getName();
                    if (psiElement instanceof JadeAttributeValueImpl && ((JadeAttributeValueImpl)psiElement).isSyntheticClass()) {
                        return true;
                    }
                    if (CssInJadeElementFilter.isSuitableAttribute(attrName) && xmlAttribute.getParent().getNamespacePrefix().isEmpty()) {
                        return true;
                    }
                }
                return false;
            }

            private static boolean isSuitableAttribute(String attrName) {
                return "class".equalsIgnoreCase(attrName) || "id".equalsIgnoreCase(attrName);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }
    }
}

