/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.psi.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.jetbrains.plugins.jade.JadeToPugTransitionHelper;
import com.jetbrains.plugins.jade.psi.JadeFileType;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import com.jetbrains.plugins.jade.psi.impl.JadeFilePathImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JadeFileReferenceSet
extends FileReferenceSet {
    private final boolean myAllFiles;
    @NotNull
    private final String myExtension;

    public JadeFileReferenceSet(@NotNull JadeFilePathImpl element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet", "<init>"));
        }
        super((PsiElement)element);
        this.myAllFiles = element.getParent().getFirstChild().getNode().getElementType() == JadeTokenTypes.INCLUDE_KEYWORD;
        this.myExtension = JadeToPugTransitionHelper.isPugElement((PsiElement)element) ? "pug" : "jade";
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        FileTypeManager manager = FileTypeManager.getInstance();
        return psiFileSystemItem -> {
            if (psiFileSystemItem.isDirectory()) {
                return true;
            }
            if (this.getElement().getContainingFile().getOriginalFile().equals(psiFileSystemItem)) {
                return false;
            }
            return this.myAllFiles || manager.getFileTypeByFileName(psiFileSystemItem.getName()) instanceof JadeFileType;
        };
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new FileReference(this, range, index, text){

            protected Object createLookupItem(PsiElement candidate) {
                if (!(candidate instanceof PsiFile) || !candidate.isPhysical()) {
                    return candidate;
                }
                PsiFile file = (PsiFile)candidate;
                String name = file.getName();
                String lookupString = FileUtilRt.extensionEquals((String)name, (String)JadeFileReferenceSet.this.myExtension) ? FileUtil.getNameWithoutExtension((String)name) : name;
                return LookupElementBuilder.create((Object)file, (String)lookupString).withIcon(file.getIcon(0)).withPresentableText(name);
            }

            private String patchText(String text) {
                if (!this.isLast()) {
                    return text;
                }
                String extension = FileUtilRt.getExtension((String)text);
                if (JadeFileReferenceSet.this.myAllFiles && !extension.isEmpty()) {
                    return text;
                }
                if (!FileUtil.namesEqual((String)JadeFileReferenceSet.this.myExtension, (String)extension)) {
                    return text + "." + JadeFileReferenceSet.this.myExtension;
                }
                return text;
            }

            protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result, boolean caseSensitive) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet$1", "innerResolveInContext"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet$1", "innerResolveInContext"));
                }
                super.innerResolveInContext(this.patchText(text), context, result, caseSensitive);
            }

            @NotNull
            public String getFileNameToCreate() {
                String string = this.patchText(this.getCanonicalText());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet$1", "getFileNameToCreate"));
                }
                return string;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                String text = StringUtil.escapePattern((String)this.decode(this.getCanonicalText()));
                String string = LangBundle.message((String)"error.cannot.resolve", (Object[])new Object[0]) + " " + LangBundle.message((String)(this.isLast() ? "terms.file" : "terms.directory"), (Object[])new Object[0]) + " '" + this.patchText(text) + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet$1", "getUnresolvedMessagePattern"));
                }
                return string;
            }
        };
    }
}

