/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.todo;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.plugins.jade.lexer.JadeLexer;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeIndexPatternBuilder
implements IndexPatternBuilder {
    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/jade/todo/JadeIndexPatternBuilder", "getIndexingLexer"));
        }
        if (file instanceof JadeFileImpl) {
            return new JadeLexer(CodeStyleSettingsManager.getInstance((Project)file.getProject()).getCurrentSettings());
        }
        return null;
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/jade/todo/JadeIndexPatternBuilder", "getCommentTokenSet"));
        }
        return JadeTokenTypes.COMMENTS;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        if (tokenType == JadeTokenTypes.COMMENT) {
            return 2;
        }
        return 3;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return 0;
    }
}

