/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.validation;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.plugins.jade.JadeBundle;
import com.jetbrains.plugins.jade.JadeLanguage;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeTabsAndSpacesInspection
extends LocalInspectionTool {
    private static final LocalQuickFix FORMAT_QUICKFIX = new LocalQuickFix(){

        @NotNull
        public String getName() {
            if ("Reformat code" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/validation/JadeTabsAndSpacesInspection$1", "getName"));
            }
            return "Reformat code";
        }

        @NotNull
        public String getFamilyName() {
            if ("Jade" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/validation/JadeTabsAndSpacesInspection$1", "getFamilyName"));
            }
            return "Jade";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/jade/validation/JadeTabsAndSpacesInspection$1", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/plugins/jade/validation/JadeTabsAndSpacesInspection$1", "applyFix"));
            }
            PsiFile file = descriptor.getStartElement().getContainingFile();
            new ReformatCodeProcessor(project, file, file.getTextRange(), false).run();
        }
    };

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/jade/validation/JadeTabsAndSpacesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/plugins/jade/validation/JadeTabsAndSpacesInspection", "checkFile"));
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>(2);
        if (file.getLanguage() != JadeLanguage.INSTANCE) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String text = file.getText();
        TextRange lastRange = null;
        char lastCharType = '\u0000';
        int newline = -1;
        while ((newline = text.indexOf("\n", newline + 1)) != -1 && text.length() != newline + 1) {
            int firstDifferent;
            char firstCharAfterNewline = text.charAt(newline + 1);
            if (firstCharAfterNewline != ' ' && firstCharAfterNewline != '\t') continue;
            for (firstDifferent = newline + 2; firstDifferent < text.length() && text.charAt(firstDifferent) == firstCharAfterNewline; ++firstDifferent) {
            }
            if (lastCharType != '\u0000' && lastCharType != firstCharAfterNewline) {
                result.add(JadeTabsAndSpacesInspection.reportProblem(manager, file, lastRange));
                result.add(JadeTabsAndSpacesInspection.reportProblem(manager, file, TextRange.create((int)(newline + 1), (int)firstDifferent)));
                break;
            }
            if (firstDifferent == text.length()) break;
            char firstDifferentChar = text.charAt(firstDifferent);
            if (firstDifferentChar == ' ' || firstDifferentChar == '\t') {
                result.add(JadeTabsAndSpacesInspection.reportProblem(manager, file, TextRange.create((int)(firstDifferent - 1), (int)firstDifferent)));
                result.add(JadeTabsAndSpacesInspection.reportProblem(manager, file, TextRange.create((int)firstDifferent, (int)(firstDifferent + 1))));
                break;
            }
            lastCharType = firstCharAfterNewline;
            lastRange = TextRange.create((int)(newline + 1), (int)firstDifferent);
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    private static ProblemDescriptor reportProblem(InspectionManager manager, PsiFile file, TextRange range) {
        PsiElement at = file.findElementAt(range.getStartOffset());
        if (at == null) {
            throw new IndexOutOfBoundsException("could not find element at index");
        }
        return manager.createProblemDescriptor(at, range.shiftRight(-at.getTextOffset()), JadeBundle.message("inspections.tabs.and.spaces.name", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{FORMAT_QUICKFIX});
    }
}

