/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.watcher;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.jetbrains.plugins.jade.JadeToPugTransitionHelper;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import com.jetbrains.plugins.jade.psi.JadeFileType;
import com.jetbrains.plugins.jade.psi.impl.JadeIncludeStatementImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("jade" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider", "getId"));
        }
        return "jade";
    }

    public boolean acceptFile(VirtualFile file) {
        return file.getFileType() instanceof JadeFileType;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)JadeFileType.INSTANCE);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile instanceof JadeFileImpl) {
            FileIncludeInfo[] fileIncludeInfoArray = JadeFileIncludeProvider.getIncludeInfos((JadeFileImpl)psiFile);
            if (fileIncludeInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider", "getIncludeInfos"));
            }
            return fileIncludeInfoArray;
        }
        if (FileIncludeInfo.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider", "getIncludeInfos"));
        }
        return FileIncludeInfo.EMPTY;
    }

    private static FileIncludeInfo[] getIncludeInfos(JadeFileImpl file) {
        final ArrayList result = new ArrayList();
        final String fileExtension = "." + JadeToPugTransitionHelper.getExtension((PsiFile)file);
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof JadeIncludeStatementImpl) {
                    String path = JadeFileIncludeProvider.extractPath(fileExtension, (JadeIncludeStatementImpl)element);
                    if (path != null) {
                        result.add(new FileIncludeInfo(path));
                    }
                } else {
                    super.visitElement(element);
                }
            }
        });
        return (FileIncludeInfo[])ContainerUtil.toArray(result, (Object[])FileIncludeInfo.EMPTY);
    }

    @Nullable
    private static String extractPath(@NotNull String fileExtension, @NotNull JadeIncludeStatementImpl includeStatement) {
        PsiElement[] children;
        if (fileExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtension", "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider", "extractPath"));
        }
        if (includeStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includeStatement", "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider", "extractPath"));
        }
        for (PsiElement child : children = includeStatement.getChildren()) {
            ASTNode node;
            if (!(child instanceof ASTNode) || (node = (ASTNode)child).getElementType() != JadeElementTypes.FILE_PATH) continue;
            String path = child.getText();
            if (!path.endsWith(fileExtension)) {
                path = path + fileExtension;
            }
            return path;
        }
        return null;
    }
}

