/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import com.jetbrains.plugins.jade.JadeToPugTransitionHelper;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import org.jetbrains.annotations.NotNull;

public class JadeOrPugTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/jade/watcher/JadeOrPugTaskConsumer", "isAvailable"));
        }
        return file instanceof JadeFileImpl;
    }

    public String getConsumeMessage() {
        return "Enable File Watcher to compile Pug to HTML?";
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName("Pug/Jade");
        options.setDescription("Compiles .pug and .jade files into .html files");
        options.setFileExtension(StringUtil.join(JadeToPugTransitionHelper.ALL_EXTENSIONS, (String)";"));
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        options.setArguments("$" + new FileNameMacro().getName() + "$");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setOutput("$" + new FileNameWithoutExtension().getName() + "$.html");
        options.setProgram(JadeOrPugTaskConsumer.findExecutableInPath((String)(SystemInfo.isWindows ? "pug.cmd" : "pug")));
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/watcher/JadeOrPugTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }
}

