/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.lang.Language;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JspxFileViewProviderImpl
extends MultiplePsiFilesPerDocumentFileViewProvider
implements JspxFileViewProvider {
    public JspxFileViewProviderImpl(PsiManager manager, VirtualFile virtualFile, boolean isPhysical) {
        super(manager, virtualFile, isPhysical);
    }

    @NotNull
    public Language getBaseLanguage() {
        JSPXLanguage jSPXLanguage = JSPXLanguage.INSTANCE;
        if (jSPXLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspxFileViewProviderImpl", "getBaseLanguage"));
        }
        return jSPXLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        XHTMLLanguage xHTMLLanguage = XHTMLLanguage.INSTANCE;
        if (xHTMLLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspxFileViewProviderImpl", "getTemplateDataLanguage"));
        }
        return xHTMLLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        LinkedHashSet<Language> set = new LinkedHashSet<Language>(2);
        set.add((Language)JSPXLanguage.INSTANCE);
        set.add(JspWithOtherWorldIntegrationService.getJavaLanguage());
        LinkedHashSet<Language> linkedHashSet = set;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspxFileViewProviderImpl", "getLanguages"));
        }
        return linkedHashSet;
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "com/intellij/lang/jsp/JspxFileViewProviderImpl", "supportsIncrementalReparse"));
        }
        return this.getBaseLanguage() != JSPXLanguage.INSTANCE || rootLanguage != JspWithOtherWorldIntegrationService.getJavaLanguage();
    }

    protected PsiFile getPsiInner(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/jsp/JspxFileViewProviderImpl", "getPsiInner"));
        }
        if (target == XHTMLLanguage.INSTANCE && this.getBaseLanguage() == JSPXLanguage.INSTANCE) {
            target = JSPXLanguage.INSTANCE;
        }
        return super.getPsiInner(target);
    }

    protected JspxFileViewProviderImpl cloneInner(VirtualFile copy) {
        return new JspxFileViewProviderImpl(this.getManager(), copy, false);
    }

    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/lang/jsp/JspxFileViewProviderImpl", "createFile"));
        }
        if (lang == JspWithOtherWorldIntegrationService.getJavaLanguage()) {
            return JspWithOtherWorldIntegrationService.getInstance().createJavaFile(this);
        }
        return super.createFile(lang);
    }

    public boolean isFacelets() {
        return false;
    }
}

