/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataFile
extends PsiFileImpl
implements XmlFile {
    public TemplateDataFile(IFileElementType templateElementType, FileViewProvider provider) {
        super((IElementType)templateElementType, (IElementType)templateElementType, provider);
    }

    public boolean isPhysical() {
        return this.getFile().isPhysical();
    }

    public PsiDirectory getContainingDirectory() {
        return this.getFile().getContainingDirectory();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getFile().getViewProvider().getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataFile", "getFileType"));
        }
        return fileType;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/templateLanguages/TemplateDataFile", "accept"));
        }
        visitor.visitFile((PsiFile)this);
    }

    @Nullable
    public PsiDirectory getParent() {
        return null;
    }

    private PsiFile getFile() {
        return PsiUtilCore.getTemplateLanguageFile((PsiElement)this);
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = this.getFile().getPsiRoots();
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataFile", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile original = super.getOriginalFile();
        if (original == this) {
            PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)this);
            PsiFile jspOriginal = psiFile.getOriginalFile();
            PsiFile psiFile2 = jspOriginal.getViewProvider().getPsi(this.getLanguage());
            if (psiFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataFile", "getOriginalFile"));
            }
            return psiFile2;
        }
        PsiFile psiFile = original;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataFile", "getOriginalFile"));
        }
        return psiFile;
    }

    @NotNull
    public Language getLanguage() {
        Language language = ((TemplateLanguageFileViewProvider)this.getViewProvider()).getTemplateDataLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataFile", "getLanguage"));
        }
        return language;
    }

    public boolean isTemplateDataFile() {
        return true;
    }

    public XmlDocument getDocument() {
        return (XmlDocument)this.findChildByClass(XmlDocument.class);
    }

    public XmlTag getRootTag() {
        XmlDocument document = this.getDocument();
        return document == null ? null : document.getRootTag();
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor, place);
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope((Project)this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataFile", "getFileResolveScope"));
        }
        return globalSearchScope;
    }

    public boolean ignoreReferencedElementAccessibility() {
        return false;
    }
}

