/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.JavaScriptStepDefinition;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.NotIndexedCucumberExtension;

public class CucumberJavaScriptExtension
extends NotIndexedCucumberExtension {
    protected void loadStepDefinitionRootsFromLibraries(Module module, List<PsiDirectory> roots, Set<String> directories) {
    }

    protected Collection<AbstractStepDefinition> getStepDefinitions(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "getStepDefinitions"));
        }
        PlainGherkinKeywordProvider keywordProvider = new PlainGherkinKeywordProvider();
        final Collection stepKeywords = keywordProvider.getKeywordsTable("en").getStepKeywords();
        final ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        file.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression argument;
                String calledMethodName = node.getMethodExpression().getText();
                if (stepKeywords.contains(calledMethodName = StringUtil.trimStart((String)calledMethodName, (String)"this.")) && node.getArguments().length >= 2 && ((argument = node.getArguments()[0]) instanceof JSLiteralExpression && ((JSLiteralExpression)argument).isRegExpLiteral() || argument instanceof JSStringTemplateExpression)) {
                    result.add(new JavaScriptStepDefinition((PsiElement)argument));
                    return;
                }
                super.visitJSCallExpression(node);
            }
        });
        return result;
    }

    protected void collectAllStepDefsProviders(@NotNull List<VirtualFile> providers, @NotNull Project project) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "collectAllStepDefsProviders"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "collectAllStepDefsProviders"));
        }
    }

    public void findRelatedStepDefsRoots(final @NotNull Module module, @NotNull PsiFile featureFile, final @NotNull List<PsiDirectory> newStepDefinitionsRoots, final @NotNull Set<String> processedStepDirectories) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "findRelatedStepDefsRoots"));
        }
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "findRelatedStepDefsRoots"));
        }
        if (newStepDefinitionsRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStepDefinitionsRoots", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "findRelatedStepDefsRoots"));
        }
        if (processedStepDirectories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedStepDirectories", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "findRelatedStepDefsRoots"));
        }
        VirtualFile file = featureFile.getVirtualFile();
        if (file == null) {
            return;
        }
        VirtualFile contentRoot = CucumberJavaScriptExtension.findContentRoot((Module)module, (VirtualFile)file);
        if (contentRoot == null) {
            return;
        }
        ProjectRootManager.getInstance((Project)featureFile.getProject()).getFileIndex().iterateContentUnderDirectory(contentRoot, new ContentIterator(){

            public boolean processFile(VirtualFile stepDefsRoot) {
                if (CucumberJavaScriptUtil.isStepDefinitionsRoot(stepDefsRoot)) {
                    CucumberJavaScriptExtension.addStepDefsRootIfNecessary((VirtualFile)stepDefsRoot, (List)newStepDefinitionsRoots, (Set)processedStepDirectories, (Project)module.getProject());
                }
                return true;
            }
        });
    }

    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "isStepLikeFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "isStepLikeFile"));
        }
        return parent instanceof PsiDirectory && child instanceof JSFileImpl;
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "isWritableStepLikeFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "isWritableStepLikeFile"));
        }
        return this.isStepLikeFile(child, parent);
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        BDDFrameworkType bDDFrameworkType = new BDDFrameworkType((FileType)JavaScriptFileType.INSTANCE);
        if (bDDFrameworkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "getStepFileType"));
        }
        return bDDFrameworkType;
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        CucumberJavaScriptStepDefinitionCreator cucumberJavaScriptStepDefinitionCreator = new CucumberJavaScriptStepDefinitionCreator();
        if (cucumberJavaScriptStepDefinitionCreator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "getStepDefinitionCreator"));
        }
        return cucumberJavaScriptStepDefinitionCreator;
    }

    @NotNull
    public Collection<String> getGlues(@NotNull GherkinFile file, Set<String> gluesFromOtherFiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "getGlues"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptExtension", "getGlues"));
        }
        return list;
    }
}

