/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class CucumberJavaScriptStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final List<String> FORBIDDEN_STEP_KEYWORD = Arrays.asList("And", "But", "*");
    private static final String JAVASCRIPT_FILE_EXTENSION = '.' + JavaScriptFileType.INSTANCE.getDefaultExtension();
    private static final String DEFAULT_ARGUMENT_NAME = "arg";
    public static final String STRING_ARGUMENT_REGEX = "(\"[^\"]*\")";
    public static final String NUMBER_ARGUMENT_REGEX = "(?:^|[ ])(\\d+)(?:[ ]|$)";
    private static Pattern PARAM_REGEXP = Pattern.compile("(\"[^\"]*\")|(?:^|[ ])(\\d+)(?:[ ]|$)");

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        PsiFile psiFile = (PsiFile)WriteAction.compute(() -> {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "lambda$createStepDefinitionContainer$0"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "lambda$createStepDefinitionContainer$0"));
            }
            return dir.createFile(name + JAVASCRIPT_FILE_EXTENSION);
        });
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "createStepDefinitionContainer"));
        }
        return psiFile;
    }

    private static JSFunction findWrapper(JSFile jsFile) {
        for (JSSourceElement st : jsFile.getStatements()) {
            JSExpression varInitializer;
            JSVariable[] variables;
            if (!(st instanceof JSVarStatement) || (variables = ((JSVarStatement)st).getVariables()).length != 1 || (varInitializer = variables[0].getInitializer()) == null || !(varInitializer instanceof JSFunction)) continue;
            return (JSFunction)varInitializer;
        }
        return null;
    }

    private static PsiElement generateStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        String keyword;
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "generateStepDefinition"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "generateStepDefinition"));
        }
        if (FORBIDDEN_STEP_KEYWORD.contains(step.getKeyword().getText())) {
            PsiElement prevStep = step.getPrevSibling();
            while (prevStep instanceof GherkinStep && FORBIDDEN_STEP_KEYWORD.contains(((GherkinStep)prevStep).getKeyword().getText()) || prevStep instanceof PsiWhiteSpace) {
                prevStep = prevStep.getPrevSibling();
            }
            keyword = prevStep instanceof GherkinStep ? ((GherkinStep)prevStep).getKeyword().getText() : "Given";
        } else {
            keyword = step.getKeyword().getText();
        }
        String template = "this.%s(/^%s$/, function (%scallback) {\n  callback.pending();\n});\n";
        String params = CucumberJavaScriptStepDefinitionCreator.getArguments(step);
        String stepRegex = CucumberJavaScriptStepDefinitionCreator.getStepRegex(step);
        String elementText = String.format("this.%s(/^%s$/, function (%scallback) {\n  callback.pending();\n});\n", keyword, stepRegex, params);
        ASTNode expression = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)elementText, (JSLanguageDialect)JSUtils.getDialect((PsiFile)file));
        return expression.getPsi();
    }

    private static String getStepRegex(GherkinStep step) {
        String result = step.getStepName();
        result = CucumberUtil.prepareStepRegexp((String)result);
        return result;
    }

    private static String getArguments(GherkinStep step) {
        String result;
        ArrayList<String> arguments = new ArrayList<String>();
        Matcher m = PARAM_REGEXP.matcher(step.getStepName());
        int i = 0;
        while (m.find()) {
            String argument = m.group();
            if (argument.startsWith("<")) {
                arguments.add(argument.substring(1, argument.length() - 1));
                continue;
            }
            arguments.add(DEFAULT_ARGUMENT_NAME + ++i);
        }
        if (step.getPystring() != null) {
            arguments.add("text");
        }
        if ((result = StringUtil.join(arguments, (String)", ")).length() > 0) {
            result = result + ", ";
        }
        return result;
    }

    private static JSFunction createStepDefsWrapper(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "createStepDefsWrapper"));
        }
        String text = "var myStepDefinitionsWrapper = function () {\n};";
        ASTNode varStatementNode = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)"var myStepDefinitionsWrapper = function () {\n};", (JSLanguageDialect)JSUtils.getDialect((PsiFile)file));
        JSVarStatement varStatement = (JSVarStatement)varStatementNode.getPsi();
        varStatement = (JSVarStatement)file.add((PsiElement)varStatement);
        String exportModuleText = "module.exports = myStepDefinitionsWrapper;";
        ASTNode exportModuleNode = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)"module.exports = myStepDefinitionsWrapper;", (JSLanguageDialect)JSUtils.getDialect((PsiFile)file));
        PsiElement exportModuleElement = exportModuleNode.getPsi();
        file.add(exportModuleElement);
        JSVariable variable = varStatement.getVariables()[0];
        return (JSFunctionExpression)variable.getInitializer();
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        PsiElement blockCandidate;
        PsiElement stepDefinition;
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "createStepDefinition"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "createStepDefinition"));
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        this.closeActiveTemplateBuilders(file);
        JSFunction stepDefContainer = CucumberJavaScriptStepDefinitionCreator.findWrapper((JSFile)file);
        if (stepDefContainer == null) {
            stepDefContainer = CucumberJavaScriptStepDefinitionCreator.createStepDefsWrapper(file);
        }
        if ((stepDefinition = CucumberJavaScriptStepDefinitionCreator.generateStepDefinition(step, file)) != null && (blockCandidate = stepDefContainer.getLastChild()) instanceof JSBlockStatement) {
            if (blockCandidate.getChildren().length > 0) {
                JSChangeUtil.addWs((ASTNode)blockCandidate.getNode(), (ASTNode)blockCandidate.getLastChild().getNode(), (String)"\n");
            }
            stepDefinition = JSChangeUtil.doAddBefore((PsiElement)blockCandidate, (PsiElement)stepDefinition, (PsiElement)blockCandidate.getLastChild());
            CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(blockCandidate.getNode(), stepDefinition.getNode());
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            assert (editor != null);
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(stepDefinition);
            JSCallExpression callExpression = (JSCallExpression)stepDefinition.getFirstChild();
            JSExpression[] argumentList = callExpression.getArguments();
            if (argumentList.length > 1) {
                JSSourceElement stepDefBody;
                PsiElement[] stepDefElements;
                JSSourceElement[] body;
                JSExpression stepFunction;
                JSExpression regex = argumentList[0];
                if (regex.getTextLength() > 4) {
                    TextRange regexRange = new TextRange(2, regex.getTextLength() - 2);
                    builder.replaceElement((PsiElement)regex, regexRange, regexRange.substring(regex.getText()));
                }
                if ((stepFunction = argumentList[1]) instanceof JSFunction && (body = ((JSFunction)stepFunction).getBody()).length > 0 && (stepDefElements = (stepDefBody = body[0]).getChildren()).length > 0) {
                    PsiElement pendingElement = stepDefElements[0];
                    TextRange pendingRange = new TextRange(0, pendingElement.getTextLength() - 1);
                    builder.replaceElement(pendingElement, pendingRange, pendingRange.substring(pendingElement.getText()));
                }
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            builder.run(editor, false);
        }
        return false;
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "validateNewStepDefinitionFileName"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "validateNewStepDefinitionFileName"));
        }
        return true;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "getDefaultStepFileName"));
        }
        if ("my_steps" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator", "getDefaultStepFileName"));
        }
        return "my_steps";
    }
}

