/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunnerParameters;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunningState;
import org.jetbrains.plugins.cucumber.javascript.run.ui.CucumberJavaScriptConfigurationEditorForm;

public class CucumberJavaScriptRunConfiguration
extends LocatableConfigurationBase {
    private final CucumberJavaScriptRunnerParameters myRunnerParameters = new CucumberJavaScriptRunnerParameters();

    protected CucumberJavaScriptRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        CucumberJavaScriptConfigurationEditorForm cucumberJavaScriptConfigurationEditorForm = new CucumberJavaScriptConfigurationEditorForm(this.getProject());
        if (cucumberJavaScriptConfigurationEditorForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfiguration", "getConfigurationEditor"));
        }
        return cucumberJavaScriptConfigurationEditorForm;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfiguration", "getState"));
        }
        Project project = env.getProject();
        String path = this.myRunnerParameters.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new ExecutionException("Can't find file: " + path);
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        assert (virtualFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            throw new ExecutionException("Can't find module for file");
        }
        return new CucumberJavaScriptRunningState(env, this.myRunnerParameters, this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        String path = this.myRunnerParameters.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new RuntimeConfigurationException("Can't find file: " + path);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public CucumberJavaScriptRunnerParameters getRunnerParameters() {
        return this.myRunnerParameters;
    }
}

