/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfiguration;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunnerParameters;

public class CucumberJavaScriptRunningState
extends CommandLineState {
    private final CucumberJavaScriptRunnerParameters myRunnerParameters;
    private final CucumberJavaScriptRunConfiguration myRunConfiguration;

    public CucumberJavaScriptRunningState(ExecutionEnvironment env, CucumberJavaScriptRunnerParameters runnerParameters, CucumberJavaScriptRunConfiguration runConfiguration) {
        super(env);
        this.myRunnerParameters = runnerParameters;
        this.myRunConfiguration = runConfiguration;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        GeneralCommandLine commandLine = this.getCommand();
        OSProcessHandler oSProcessHandler = new OSProcessHandler(commandLine);
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState", "startProcess"));
        }
        return oSProcessHandler;
    }

    public GeneralCommandLine getCommand() throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (this.myRunnerParameters.getFilePath() == null) {
            throw new ExecutionException("Can't find feature to run");
        }
        VirtualFile fileToRun = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)this.myRunnerParameters.getFilePath()));
        String smFormatterPath = CucumberJavaScriptUtil.getSMFormatterPath();
        if (StringUtil.isEmpty((String)this.myRunnerParameters.getExecutablePath())) {
            if (SystemInfo.isWindows) {
                String windowsCucumberPath = "cucumber-js.cmd";
                try {
                    String line;
                    Process p = Runtime.getRuntime().exec("where cucumber-js.cmd");
                    p.waitFor();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    String[] lines = sb.toString().split("\n");
                    if (lines.length > 0) {
                        windowsCucumberPath = lines[0];
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                commandLine.setExePath(windowsCucumberPath);
            } else {
                commandLine.setExePath("/usr/local/bin/cucumber.js");
            }
        } else {
            commandLine.setExePath(this.myRunnerParameters.getExecutablePath());
        }
        if (fileToRun != null) {
            if (fileToRun.getExtension() != null && fileToRun.getExtension().equals("feature")) {
                commandLine.addParameter(FileUtil.toSystemDependentName((String)fileToRun.getPath()));
            }
            if (!fileToRun.isDirectory()) {
                fileToRun = fileToRun.getParent();
            }
        } else {
            throw new ExecutionException("Can't find feature to run");
        }
        commandLine.withWorkDirectory(fileToRun.getParent().getPath());
        if (this.myRunnerParameters.getCucumberJsArguments().length() > 0) {
            commandLine.addParameters(this.myRunnerParameters.getCucumberJsArguments().split(" "));
        }
        commandLine.addParameter("--format");
        commandLine.addParameter("summary");
        commandLine.addParameter("--require");
        commandLine.addParameter(fileToRun.getPath());
        commandLine.addParameter("--require");
        commandLine.addParameter(smFormatterPath);
        return commandLine;
    }

    @Nullable
    private ConsoleView createConsole(@NotNull Executor executor, ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState", "createConsole"));
        }
        String testFrameworkName = "cucumber";
        SMTRunnerConsoleProperties consoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)this.myRunConfiguration, "cucumber", executor);
        BaseTestsOutputConsoleView testRunnerConsole = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"cucumber", (ProcessHandler)processHandler, (TestConsoleProperties)consoleProperties);
        Disposer.register((Disposable)this.myRunConfiguration.getProject(), (Disposable)testRunnerConsole);
        return testRunnerConsole;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState", "execute"));
        }
        ProcessHandler processHandler = this.startProcess();
        ConsoleView console = this.createConsole(executor, processHandler);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, processHandler, this.createActions(console, processHandler, executor));
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunningState", "execute"));
        }
        return defaultExecutionResult;
    }
}

