/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptBundle;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfiguration;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;

public class CucumberJavaScriptConfigurationEditorForm
extends SettingsEditor<CucumberJavaScriptRunConfiguration> {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myFileField;
    private JTextField myCucumberArguments;
    private TextFieldWithBrowseButton myExecutablePath;

    public CucumberJavaScriptConfigurationEditorForm(Project project) {
        this.$$$setupUI$$$();
        FileChooserDescriptor fileToRunChooser = new FileChooserDescriptor(true, true, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || file.getFileType() == GherkinFileType.INSTANCE;
            }

            public boolean isFileSelectable(VirtualFile file) {
                return this.isFileVisible(file, false);
            }
        };
        String chooseFileToRunMessage = CucumberJavaScriptBundle.message("choose.gherkin.file.or.directory", new Object[0]);
        this.myFileField.addBrowseFolderListener(chooseFileToRunMessage, chooseFileToRunMessage, project, fileToRunChooser);
        FileChooserDescriptor executableChooser = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        String chooseExecutableMessage = CucumberJavaScriptBundle.message("cucumber.js.run.choose.executable.path.title", new Object[0]);
        this.myExecutablePath.addBrowseFolderListener(chooseExecutableMessage, chooseExecutableMessage, project, executableChooser);
    }

    protected void resetEditorFrom(@NotNull CucumberJavaScriptRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/cucumber/javascript/run/ui/CucumberJavaScriptConfigurationEditorForm", "resetEditorFrom"));
        }
        this.myFileField.setText(configuration.getRunnerParameters().getFilePath());
        this.myCucumberArguments.setText(configuration.getRunnerParameters().getCucumberJsArguments());
        this.myExecutablePath.setText(configuration.getRunnerParameters().getExecutablePath());
    }

    protected void applyEditorTo(@NotNull CucumberJavaScriptRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/cucumber/javascript/run/ui/CucumberJavaScriptConfigurationEditorForm", "applyEditorTo"));
        }
        configuration.getRunnerParameters().setFilePath(this.myFileField.getText());
        configuration.getRunnerParameters().setCucumberJsArguments(this.myCucumberArguments.getText());
        configuration.getRunnerParameters().setExecutablePath(this.myExecutablePath.getText());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/javascript/run/ui/CucumberJavaScriptConfigurationEditorForm", "createEditor"));
        }
        return jPanel;
    }

    protected void disposeEditor() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("choose.gherkin.file.or.directory.element.label"));
        jLabel.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCucumberArguments = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("cucumber.js.run.arguments.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("cucumber.js.run.executable.path.label"));
        jLabel3.setHorizontalTextPosition(4);
        jLabel3.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myExecutablePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

