/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config;

import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.LocalSettings;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CvsApplicationLevelConfiguration", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public class CvsApplicationLevelConfiguration
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration");
    public List<CvsRootConfiguration> CONFIGURATIONS = new ArrayList<CvsRootConfiguration>();
    public ExtConfiguration EXT_CONFIGURATION = new ExtConfiguration();
    public SshSettings SSH_CONFIGURATION = new SshSettings();
    public LocalSettings LOCAL_CONFIGURATION = new LocalSettings();
    public ProxySettings PROXY_SETTINGS = new ProxySettings();
    public SshSettings SSH_FOR_EXT_CONFIGURATION = new SshSettings();
    @NonNls
    private static final String CONFIGURATION_ELEMENT_NAME = "Configuration";
    public String PATH_TO_PASSWORD_FILE = null;
    public int TIMEOUT = 10;
    public boolean MAKE_CHECKED_OUT_FILES_READONLY = false;
    public boolean CHECKOUT_PRUNE_EMPTY_DIRECTORIES = true;
    public String CHECKOUT_KEYWORD_SUBSTITUTION = null;
    public boolean SHOW_RESTORE_DIRECTORIES_CONFIRMATION = true;
    @NotNull
    public String ENCODING = "Default";
    public boolean USE_GZIP = false;
    @NonNls
    public static final String DEFAULT = "Default";
    public boolean DO_OUTPUT = false;
    public boolean SEND_ENVIRONMENT_VARIABLES_TO_SERVER = false;
    public boolean SHOW_PATH = true;

    public static CvsApplicationLevelConfiguration getInstance() {
        return (CvsApplicationLevelConfiguration)ServiceManager.getService(CvsApplicationLevelConfiguration.class);
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)state, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)new CvsApplicationLevelConfiguration()));
        for (CvsRootConfiguration configuration : this.CONFIGURATIONS) {
            Element child = new Element(CONFIGURATION_ELEMENT_NAME);
            configuration.writeExternal(child);
            state.addContent(child);
        }
        return state;
    }

    public void loadState(Element state) {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        for (Element child : state.getChildren(CONFIGURATION_ELEMENT_NAME)) {
            this.CONFIGURATIONS.add(this.createConfigurationOn(child));
        }
        if (!CvsApplicationLevelConfiguration.encodingExists(this.ENCODING)) {
            this.ENCODING = DEFAULT;
        }
        this.updateConfigurations();
    }

    private static boolean encodingExists(String encoding) {
        Charset[] availableCharsets;
        for (Charset availableCharset : availableCharsets = CharsetToolkit.getAvailableCharsets()) {
            if (!availableCharset.name().equals(encoding)) continue;
            return true;
        }
        return false;
    }

    private CvsRootConfiguration createConfigurationOn(Element child) {
        CvsRootConfiguration config = CvsApplicationLevelConfiguration.createNewConfiguration(this);
        config.readExternal(child);
        return config;
    }

    private boolean passFileExists() {
        if (this.PATH_TO_PASSWORD_FILE == null) {
            return false;
        }
        return new File(CvsApplicationLevelConfiguration.convertToIOFilePath(this.PATH_TO_PASSWORD_FILE)).isFile();
    }

    public static String convertToIOFilePath(String presentation) {
        String userHome = SystemProperties.getUserHome().replace(File.separatorChar, '/');
        presentation = presentation.replace(File.separatorChar, '/');
        try {
            String result = StringUtil.replace((String)presentation, (String)"$userdir", (String)userHome);
            result = result.replace('/', File.separatorChar);
            return result;
        }
        catch (Exception ex) {
            LOG.error("userHome = " + userHome + ", presentation = " + presentation);
            return "";
        }
    }

    public File getPassFile() {
        return new File(CvsApplicationLevelConfiguration.convertToIOFilePath(this.getPathToPassFilePresentation()));
    }

    public String getPathToPassFilePresentation() {
        if (!this.passFileExists()) {
            this.PATH_TO_PASSWORD_FILE = "$userdir/.cvspass";
        }
        return this.PATH_TO_PASSWORD_FILE;
    }

    public CvsRootConfiguration getConfigurationForCvsRoot(String root) {
        for (CvsRootConfiguration cvsRootConfiguration : this.CONFIGURATIONS) {
            if (!cvsRootConfiguration.getCvsRootAsString().equals(root)) continue;
            return cvsRootConfiguration;
        }
        CvsRootConfiguration newConfig = CvsApplicationLevelConfiguration.createNewConfiguration(this);
        newConfig.CVS_ROOT = root;
        this.CONFIGURATIONS.add(newConfig);
        return newConfig;
    }

    @NotNull
    public static String getCharset() {
        String value = CvsApplicationLevelConfiguration.getInstance().ENCODING;
        if (DEFAULT.equals(value)) {
            String string = CharsetToolkit.getDefaultSystemCharset().name();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/config/CvsApplicationLevelConfiguration", "getCharset"));
            }
            return string;
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/config/CvsApplicationLevelConfiguration", "getCharset"));
        }
        return string;
    }

    public void setPathToPasswordFile(String text) {
        this.PATH_TO_PASSWORD_FILE = text;
        this.updateConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigurations() {
        File passFile = this.getPassFile();
        if (!passFile.isFile()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(passFile)));){
            String line;
            while ((line = reader.readLine()) != null) {
                int sepPosition = (line = StringUtil.trimStart((String)line, (String)"/1 ")).indexOf(32);
                if (sepPosition <= 0) continue;
                String cvsRoot = line.substring(0, sepPosition);
                this.tryToAddNewRoot(cvsRoot);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void tryToAddNewRoot(String cvsRoot) {
        for (CvsRootConfiguration configuration : this.CONFIGURATIONS) {
            if (!Comparing.equal((String)configuration.getCvsRootAsString(), (String)cvsRoot)) continue;
            return;
        }
        CvsRootConfiguration newConfiguration = CvsApplicationLevelConfiguration.createNewConfiguration(this);
        newConfiguration.CVS_ROOT = cvsRoot;
        this.CONFIGURATIONS.add(newConfiguration);
    }

    public static CvsRootConfiguration createNewConfiguration(CvsApplicationLevelConfiguration mainConfiguration) {
        CvsRootConfiguration result = new CvsRootConfiguration();
        result.EXT_CONFIGURATION = mainConfiguration.EXT_CONFIGURATION.clone();
        result.SSH_CONFIGURATION = mainConfiguration.SSH_CONFIGURATION.clone();
        result.SSH_FOR_EXT_CONFIGURATION = mainConfiguration.SSH_FOR_EXT_CONFIGURATION.clone();
        result.LOCAL_CONFIGURATION = mainConfiguration.LOCAL_CONFIGURATION.clone();
        result.PROXY_SETTINGS = mainConfiguration.PROXY_SETTINGS.clone();
        return result;
    }
}

