/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.AbstractSVGAnimatedLength;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMAnimatedLength;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.svg.SVGOMUseShadowRoot;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class SVGUseElementBridge
extends AbstractGraphicsNodeBridge {
    protected ReferencedElementMutationListener l;
    protected BridgeContext subCtx;

    @Override
    public String getLocalName() {
        return "use";
    }

    @Override
    public Bridge getInstance() {
        return new SVGUseElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null);
        this.associateSVGContext(bridgeContext, element, compositeGraphicsNode);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        NodeEventTarget nodeEventTarget;
        Rectangle2D rectangle2D;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        SVGOMUseElement sVGOMUseElement = (SVGOMUseElement)element;
        String string = sVGOMUseElement.getHref().getAnimVal();
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"xlink:href"});
        }
        Element element2 = bridgeContext.getReferencedElement(element, string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        SVGOMDocument sVGOMDocument2 = (SVGOMDocument)element2.getOwnerDocument();
        boolean bl = sVGOMDocument2 == sVGOMDocument;
        BridgeContext bridgeContext2 = bridgeContext;
        this.subCtx = null;
        if (!bl) {
            bridgeContext2 = this.subCtx = (BridgeContext)sVGOMDocument2.getCSSEngine().getCSSContext();
        }
        if ("symbol".equals((object5 = (Element)sVGOMDocument.importNode(element2, true, true)).getLocalName())) {
            object4 = sVGOMDocument.createElementNS("http://www.w3.org/2000/svg", "svg");
            object3 = object5.getAttributes();
            n = object3.getLength();
            for (int i = 0; i < n; ++i) {
                object2 = (Attr)object3.item(i);
                object4.setAttributeNS(object2.getNamespaceURI(), object2.getName(), object2.getValue());
            }
            object = object5.getFirstChild();
            while (object != null) {
                object4.appendChild((Node)object);
                object = object5.getFirstChild();
            }
            object5 = object4;
        }
        if ("svg".equals(object5.getLocalName())) {
            try {
                object4 = (SVGOMAnimatedLength)sVGOMUseElement.getWidth();
                if (((AbstractSVGAnimatedValue)object4).isSpecified()) {
                    object5.setAttributeNS(null, "width", ((AbstractSVGAnimatedLength)object4).getAnimVal().getValueAsString());
                }
                if (((AbstractSVGAnimatedValue)(object4 = (SVGOMAnimatedLength)sVGOMUseElement.getHeight())).isSpecified()) {
                    object5.setAttributeNS(null, "height", ((AbstractSVGAnimatedLength)object4).getAnimVal().getValueAsString());
                }
            }
            catch (LiveAttributeException liveAttributeException) {
                throw new BridgeException(bridgeContext, liveAttributeException);
            }
        }
        object4 = new SVGOMUseShadowRoot(sVGOMDocument, element, bl);
        ((AbstractParentNode)object4).appendChild((Node)object5);
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
            this.associateSVGContext(bridgeContext, element, this.node);
        } else {
            int n2 = compositeGraphicsNode.size();
            for (n = 0; n < n2; ++n) {
                compositeGraphicsNode.remove(0);
            }
        }
        object3 = sVGOMUseElement.getCSSFirstChild();
        if (object3 != null) {
            this.disposeTree((Node)object3);
        }
        sVGOMUseElement.setUseShadowTree((SVGOMUseShadowRoot)object4);
        Object object6 = object5;
        CSSUtilities.computeStyleAndURIs(element2, (Element)object5, string);
        object = bridgeContext.getGVTBuilder();
        object2 = ((GVTBuilder)object).build(bridgeContext, (Element)object6);
        compositeGraphicsNode.getChildren().add(object2);
        compositeGraphicsNode.setTransform(this.computeTransform((SVGTransformable)element, bridgeContext));
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if (renderingHints != null) {
            compositeGraphicsNode.setRenderingHints(renderingHints);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element)) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        if (this.l != null) {
            nodeEventTarget = this.l.target;
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.l, true);
            this.l = null;
        }
        if (bl && bridgeContext.isDynamic()) {
            this.l = new ReferencedElementMutationListener();
            this.l.target = nodeEventTarget = (NodeEventTarget)((Object)element2);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.l, true, null);
            bridgeContext2.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMAttrModified", this.l, true);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.l, true, null);
            bridgeContext2.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.l, true);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.l, true, null);
            bridgeContext2.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.l, true);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.l, true, null);
            bridgeContext2.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.l, true);
        }
        return compositeGraphicsNode;
    }

    @Override
    public void dispose() {
        NodeEventTarget nodeEventTarget;
        if (this.l != null) {
            nodeEventTarget = this.l.target;
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.l, true);
            this.l = null;
        }
        if ((nodeEventTarget = (SVGOMUseElement)this.e) != null && ((SVGOMUseElement)nodeEventTarget).getCSSFirstChild() != null) {
            this.disposeTree(((SVGOMUseElement)nodeEventTarget).getCSSFirstChild());
        }
        super.dispose();
        this.subCtx = null;
    }

    @Override
    protected AffineTransform computeTransform(SVGTransformable sVGTransformable, BridgeContext bridgeContext) {
        AffineTransform affineTransform = super.computeTransform(sVGTransformable, bridgeContext);
        SVGUseElement sVGUseElement = (SVGUseElement)sVGTransformable;
        try {
            AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGUseElement.getX();
            float f = abstractSVGAnimatedLength.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGUseElement.getY();
            float f2 = abstractSVGAnimatedLength2.getCheckedValue();
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(f, f2);
            affineTransform2.preConcatenate(affineTransform);
            return affineTransform2;
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element);
            CursorMouseOverListener cursorMouseOverListener = new CursorMouseOverListener(bridgeContext);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", cursorMouseOverListener, false, null);
            bridgeContext.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseover", cursorMouseOverListener, false);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        try {
            String string = animatedLiveAttributeValue.getNamespaceURI();
            String string2 = animatedLiveAttributeValue.getLocalName();
            if (string == null && (string2.equals("x") || string2.equals("y") || string2.equals("transform"))) {
                this.node.setTransform(this.computeTransform((SVGTransformable)this.e, this.ctx));
                this.handleGeometryChanged();
            } else if (string == null && (string2.equals("width") || string2.equals("height")) || string.equals("http://www.w3.org/1999/xlink") && string2.equals("href")) {
                this.buildCompositeGraphicsNode(this.ctx, this.e, (CompositeGraphicsNode)this.node);
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(this.ctx, liveAttributeException);
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    protected class ReferencedElementMutationListener
    implements EventListener {
        protected NodeEventTarget target;

        protected ReferencedElementMutationListener() {
        }

        @Override
        public void handleEvent(Event event) {
            SVGUseElementBridge.this.buildCompositeGraphicsNode(SVGUseElementBridge.this.ctx, SVGUseElementBridge.this.e, (CompositeGraphicsNode)SVGUseElementBridge.this.node);
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected BridgeContext ctx;

        public CursorMouseOverListener(BridgeContext bridgeContext) {
            this.ctx = bridgeContext;
        }

        @Override
        public void handleEvent(Event event) {
            Cursor cursor;
            Element element = (Element)((Object)event.getCurrentTarget());
            if (!CSSUtilities.isAutoCursor(element) && (cursor = CSSUtilities.convertCursor(element, this.ctx)) != null) {
                this.ctx.getUserAgent().setSVGCursor(cursor);
            }
        }
    }
}

