/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintState
implements JSNpmLinterState<TsLintState> {
    @NotNull
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myPackagePath;
    @Nullable
    private String myCustomConfigFilePath;
    private final boolean myCustomConfigFileUsed;
    @Nullable
    private final String myRulesDirectory;
    private final boolean myAllowJs;

    public TsLintState(@NotNull NodeJsInterpreterRef nodePath, @Nullable String packagePath, boolean customConfigFileUsed, @Nullable String customConfigFilePath, @Nullable String rulesDirectory, boolean allowJs) {
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/intellij/lang/javascript/linter/tslint/config/TsLintState", "<init>"));
        }
        this.myCustomConfigFileUsed = customConfigFileUsed;
        this.myCustomConfigFilePath = customConfigFilePath;
        this.myInterpreterRef = nodePath;
        this.myPackagePath = packagePath;
        this.myRulesDirectory = rulesDirectory;
        this.myAllowJs = allowJs;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomConfigFileUsed;
    }

    @Nullable
    public String getCustomConfigFilePath() {
        return this.myCustomConfigFilePath;
    }

    public void setCustomConfigFilePath(@Nullable String customConfigFilePath) {
        this.myCustomConfigFilePath = customConfigFilePath;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/config/TsLintState", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    public String getPackagePath() {
        return this.myPackagePath;
    }

    @Nullable
    public String getRulesDirectory() {
        return this.myRulesDirectory;
    }

    public boolean isAllowJs() {
        return this.myAllowJs;
    }

    @Nullable
    public String getLinterPackagePath() {
        return this.myPackagePath;
    }

    public TsLintState withLinterPackagePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/config/TsLintState", "withLinterPackagePath"));
        }
        return new TsLintState(this.myInterpreterRef, path, this.myCustomConfigFileUsed, this.myCustomConfigFilePath, this.myRulesDirectory, this.myAllowJs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsLintState state = (TsLintState)o;
        if (this.myCustomConfigFileUsed != state.myCustomConfigFileUsed) {
            return false;
        }
        if (this.myAllowJs != state.myAllowJs) {
            return false;
        }
        if (!this.myInterpreterRef.equals((Object)state.myInterpreterRef)) {
            return false;
        }
        if (this.myPackagePath != null ? !this.myPackagePath.equals(state.myPackagePath) : state.myPackagePath != null) {
            return false;
        }
        if (this.myCustomConfigFilePath != null ? !this.myCustomConfigFilePath.equals(state.myCustomConfigFilePath) : state.myCustomConfigFilePath != null) {
            return false;
        }
        return !(this.myRulesDirectory != null ? !this.myRulesDirectory.equals(state.myRulesDirectory) : state.myRulesDirectory != null);
    }

    public int hashCode() {
        int result = this.myInterpreterRef.hashCode();
        result = 31 * result + (this.myPackagePath != null ? this.myPackagePath.hashCode() : 0);
        result = 31 * result + (this.myCustomConfigFilePath != null ? this.myCustomConfigFilePath.hashCode() : 0);
        result = 31 * result + (this.myCustomConfigFileUsed ? 1 : 0);
        result = 31 * result + (this.myRulesDirectory != null ? this.myRulesDirectory.hashCode() : 0);
        result = 31 * result + (this.myAllowJs ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TsLintState{myInterpreterRef=" + this.myInterpreterRef + ", myPackagePath='" + this.myPackagePath + '\'' + ", myCustomConfigFilePath='" + this.myCustomConfigFilePath + '\'' + ", myCustomConfigFileUsed=" + this.myCustomConfigFileUsed + ", myRulesDirectory='" + this.myRulesDirectory + '\'' + ", myAllowJs=" + this.myAllowJs + '}';
    }

    public static class Builder {
        private boolean myCustomConfigFileUsed;
        private String myCustomConfigFilePath;
        private NodeJsInterpreterRef myInterpreterRef;
        private String myPackagePath;
        private boolean myAllowJs;
        @Nullable
        private String myRulesDirectory;

        public Builder() {
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myPackagePath = "";
        }

        public Builder(@NotNull TsLintState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/config/TsLintState$Builder", "<init>"));
            }
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myPackagePath = "";
            this.myCustomConfigFileUsed = state.isCustomConfigFileUsed();
            this.myCustomConfigFilePath = state.getCustomConfigFilePath();
            this.myInterpreterRef = state.getInterpreterRef();
            this.myPackagePath = state.getPackagePath();
            this.myRulesDirectory = state.getRulesDirectory();
            this.myAllowJs = state.isAllowJs();
        }

        public Builder setCustomConfigFileUsed(boolean customConfigFileUsed) {
            this.myCustomConfigFileUsed = customConfigFileUsed;
            return this;
        }

        public Builder setCustomConfigFilePath(String customConfigFilePath) {
            this.myCustomConfigFilePath = customConfigFilePath;
            return this;
        }

        public Builder setNodePath(NodeJsInterpreterRef nodePath) {
            this.myInterpreterRef = nodePath;
            return this;
        }

        public Builder setPackagePath(String packagePath) {
            this.myPackagePath = packagePath;
            return this;
        }

        public Builder setRulesDirectory(@Nullable String rulesDirectory) {
            this.myRulesDirectory = rulesDirectory;
            return this;
        }

        public Builder setAllowJs(boolean allowJs) {
            this.myAllowJs = allowJs;
            return this;
        }

        public TsLintState build() {
            return new TsLintState(this.myInterpreterRef, this.myPackagePath, this.myCustomConfigFileUsed, this.myCustomConfigFilePath, this.myRulesDirectory, this.myAllowJs);
        }
    }
}

