/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.fix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintFixInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TsLintErrorFixAction
extends BaseIntentionAction
implements HighPriorityAction {
    @NotNull
    private final TsLinterError myError;
    private final long myModificationStamp;

    public TsLintErrorFixAction(@NotNull TsLinterError error, @NotNull Document document) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "<init>"));
        }
        this.setText(this.getFamilyName());
        this.myError = error;
        this.myModificationStamp = document.getModificationStamp();
    }

    @NotNull
    public String getText() {
        String string = TsLintBundle.message("tslint.action.fix.problems.current.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "isAvailable"));
        }
        return editor != null && editor.getDocument().getModificationStamp() == this.myModificationStamp && this.myError.getFixInfo() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "invoke"));
        }
        if (!this.isAvailable(project, editor, file)) {
            return;
        }
        TsLintFixInfo info = this.myError.getFixInfo();
        if (info == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "lambda$invoke$1"));
            }
            Document document = editor.getDocument();
            String separator = FileDocumentManager.getInstance().getLineSeparator(file.getViewProvider().getVirtualFile(), project);
            TsLintFixInfo.TsLintFixReplacements[] replacements = info.innerReplacements;
            if (replacements == null || replacements.length == 0) {
                return;
            }
            Arrays.sort(replacements, Comparator.comparingInt(el -> -el.innerStart));
            if (!this.applyReplacements(document, separator, replacements)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }, (PsiFile[])new PsiFile[0]);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
    }

    public boolean applyReplacements(@NotNull Document document, @NotNull String separator, @NotNull TsLintFixInfo.TsLintFixReplacements[] replacements) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "applyReplacements"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "applyReplacements"));
        }
        if (replacements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacements", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "applyReplacements"));
        }
        if ("\n".equals(separator)) {
            if (!this.applyFor(document.getTextLength(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "lambda$applyReplacements$2"));
                }
                document.replaceString(replacement.innerStart, replacement.innerStart + replacement.innerLength, (CharSequence)StringUtil.notNullize((String)replacement.innerText));
            }))) {
                return false;
            }
        } else {
            StringBuilder newContent = new StringBuilder(StringUtilRt.convertLineSeparators((String)document.getText(), (String)separator));
            if (!this.applyFor(newContent.length(), replacements, (Consumer<TsLintFixInfo.TsLintFixReplacements>)((Consumer)replacement -> newContent.replace(replacement.innerStart, replacement.innerStart + replacement.innerLength, StringUtil.notNullize((String)replacement.innerText))))) {
                return false;
            }
            document.setText(StringUtilRt.convertLineSeparators((CharSequence)newContent, (String)"\n"));
        }
        return true;
    }

    public boolean applyFor(int documentLength, @NotNull TsLintFixInfo.TsLintFixReplacements[] replacements, @NotNull Consumer<TsLintFixInfo.TsLintFixReplacements> apply) {
        if (replacements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacements", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "applyFor"));
        }
        if (apply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apply", "com/intellij/lang/javascript/linter/tslint/fix/TsLintErrorFixAction", "applyFor"));
        }
        for (TsLintFixInfo.TsLintFixReplacements replacement : replacements) {
            int offset = replacement.innerStart;
            if (offset > documentLength || offset + replacement.innerLength > documentLength) {
                return false;
            }
            apply.consume((Object)replacement);
        }
        return true;
    }
}

