/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.highlight;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintConfigFileSearcher;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.fix.TsLintErrorFixAction;
import com.intellij.lang.javascript.linter.tslint.fix.TsLintFileFixAction;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintInspection;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLinterInput;
import com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService;
import com.intellij.lang.javascript.linter.tslint.ui.TsLintConfigurable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintExternalAnnotator
extends JSLinterWithInspectionExternalAnnotator<TsLintState, TsLinterInput> {
    private static final TsLintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new TsLintExternalAnnotator(false);
    @NotNull
    private final TsLintConfigFileSearcher myConfigFileSearcher = new TsLintConfigFileSearcher();

    @NotNull
    public static TsLintExternalAnnotator getInstanceForBatchInspection() {
        TsLintExternalAnnotator tsLintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (tsLintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return tsLintExternalAnnotator;
    }

    public TsLintExternalAnnotator() {
        this(true);
    }

    public TsLintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @NotNull
    protected JSLinterConfigurable<TsLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "createSettingsConfigurable"));
        }
        TsLintConfigurable tsLintConfigurable = new TsLintConfigurable(project, true);
        if (tsLintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "createSettingsConfigurable"));
        }
        return tsLintConfigurable;
    }

    protected Class<? extends JSLinterConfiguration<TsLintState>> getConfigurationClass() {
        return TsLintConfiguration.class;
    }

    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return TsLintInspection.class;
    }

    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "acceptPsiFile"));
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        TsLintConfiguration configuration = TsLintConfiguration.getInstance(file.getProject());
        if (configuration.isAllowJs() && JSUtils.isJavaScriptFile((PsiFile)file)) {
            return true;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile((PsiFile)file);
        return holder != null && holder.isTypeScript;
    }

    @Nullable
    protected TsLinterInput createInfo(Project project, @NotNull PsiFile psiFile, TsLintState state, Document document, String fileContent, EditorColorsScheme colorsScheme) {
        boolean skipProcessing;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "createInfo"));
        }
        VirtualFile config = this.myConfigFileSearcher.getConfig(state, psiFile.getVirtualFile());
        boolean bl = skipProcessing = config != null && this.saveConfigFileAndReturnSkipProcessing(psiFile.getProject(), config);
        if (skipProcessing) {
            return null;
        }
        return new TsLinterInput(project, psiFile, fileContent, state, colorsScheme, config);
    }

    @Nullable
    public JSLinterAnnotationResult<TsLintState> annotate(@NotNull TsLinterInput collectedInfo) {
        JSLinterAnnotationResult<TsLintState> annotation;
        Optional<TsLinterError> globalError;
        if (collectedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "annotate"));
        }
        TsLintLanguageService service = TsLintLanguageService.getService(collectedInfo.getProject());
        VirtualFile config = collectedInfo.getConfig();
        Future<List<TsLinterError>> highlight = service.highlight(collectedInfo.getVirtualFile(), config, collectedInfo.getFileContent());
        List annotationErrors = (List)JSLanguageServiceUtil.awaitFuture(highlight);
        if (annotationErrors == null) {
            if (!service.isServiceCreated() || service.getServiceCreationError() != null) {
                String error2 = service.getServiceCreationError();
                error2 = error2 == null ? "Cannot start language service process" : error2;
                return JSLinterAnnotationResult.create((JSLinterInput)collectedInfo, (JSLinterFileLevelAnnotation)new JSLinterFileLevelAnnotation(error2), (VirtualFile)config);
            }
            return null;
        }
        if (!annotationErrors.isEmpty() && (globalError = annotationErrors.stream().filter(error -> error.isGlobal()).findFirst()).isPresent() && (annotation = TsLintExternalAnnotator.createGlobalErrorMessage(collectedInfo, config, globalError.get().getDescription())) != null) {
            return annotation;
        }
        return JSLinterAnnotationResult.createLinterResult((JSLinterInput)collectedInfo, (List)ContainerUtil.newArrayList((Iterable)annotationErrors), (VirtualFile)config);
    }

    @Nullable
    private static JSLinterAnnotationResult<TsLintState> createGlobalErrorMessage(@NotNull TsLinterInput collectedInfo, @Nullable VirtualFile config, @Nullable String error) {
        if (collectedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "createGlobalErrorMessage"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)error)) {
            ProcessOutput output = new ProcessOutput();
            output.appendStderr(error);
            IntentionAction detailsAction = JSLinterUtil.createDetailsAction((Project)collectedInfo.getProject(), (VirtualFile)collectedInfo.getVirtualFile(), null, (ProcessOutput)output, null);
            JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(error, detailsAction);
            return JSLinterAnnotationResult.create((JSLinterInput)collectedInfo, (JSLinterFileLevelAnnotation)annotation, (VirtualFile)config);
        }
        return null;
    }

    protected void cleanNotification(@NotNull TsLinterInput collectedInfo) {
        if (collectedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "cleanNotification"));
        }
        JSLinterEditorNotificationPanel.clearNotification((Project)collectedInfo.getProject(), this.getInspectionClass(), (VirtualFile)collectedInfo.getVirtualFile());
    }

    public boolean saveConfigFileAndReturnSkipProcessing(@NotNull Project project, @NotNull VirtualFile config) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "saveConfigFileAndReturnSkipProcessing"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "saveConfigFileAndReturnSkipProcessing"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (config == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "lambda$saveConfigFileAndReturnSkipProcessing$2"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "lambda$saveConfigFileAndReturnSkipProcessing$2"));
            }
            FileDocumentManager manager = FileDocumentManager.getInstance();
            Document document = manager.getCachedDocument(config);
            if (document != null) {
                boolean unsaved = manager.isDocumentUnsaved(document);
                if (unsaved) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (config == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "lambda$null$1"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "lambda$null$1"));
                        }
                        Document newDocument = manager.getCachedDocument(config);
                        if (newDocument != null) {
                            FileDocumentManager.getInstance().saveDocument(newDocument);
                        }
                        DaemonCodeAnalyzer.getInstance((Project)project).restart();
                    }, project.getDisposed());
                }
                return unsaved;
            }
            return false;
        });
    }

    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<TsLintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        TsLintConfigurable configurable = new TsLintConfigurable(file.getProject(), true);
        final Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        final IntentionAction fixAllFileIntention = new TsLintFileFixAction().asIntentionAction();
        JSLinterStandardFixes fixes = new JSLinterStandardFixes(){

            public List<IntentionAction> createListForError(@Nullable VirtualFile configFile, @NotNull UntypedJSLinterConfigurable configurable, @NotNull JSLinterErrorBase errorBase) {
                if (configurable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator$1", "createListForError"));
                }
                if (errorBase == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorBase", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator$1", "createListForError"));
                }
                List defaultIntentions = super.createListForError(configFile, configurable, errorBase);
                if (errorBase instanceof TsLinterError && ((TsLinterError)errorBase).hasFix()) {
                    ArrayList result = ContainerUtil.newArrayList();
                    if (document != null && TsLintExternalAnnotator.this.myOnTheFly) {
                        result.add(new TsLintErrorFixAction((TsLinterError)errorBase, document));
                    }
                    result.add(fixAllFileIntention);
                    result.addAll(defaultIntentions);
                    return result;
                }
                return defaultIntentions;
            }
        };
        new JSLinterAnnotationsBuilder(file, annotationResult, holder, TsLintInspection.getHighlightDisplayKey(), (UntypedJSLinterConfigurable)configurable, TsLintBundle.message("tslint.framework.title", new Object[0]) + ": ", this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply(document);
    }
}

