/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.idea.RareLogger;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintConfigFileSearcher;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintOutputJsonParser;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.service.commands.TsLintFixErrorsCommand;
import com.intellij.lang.javascript.linter.tslint.service.commands.TsLintGetErrorsCommand;
import com.intellij.lang.javascript.linter.tslint.service.protocol.TsLintLanguageServiceProtocol;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintLanguageService
extends JSLanguageServiceBase {
    @NotNull
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService"), (boolean)false);
    @NotNull
    private final TsLintConfigFileSearcher myConfigFileSearcher;

    @NotNull
    public static TsLintLanguageService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "getService"));
        }
        TsLintLanguageService tsLintLanguageService = (TsLintLanguageService)((Object)ServiceManager.getService((Project)project, TsLintLanguageService.class));
        if (tsLintLanguageService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "getService"));
        }
        return tsLintLanguageService;
    }

    public TsLintLanguageService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "<init>"));
        }
        super(project);
        this.myConfigFileSearcher = new TsLintConfigFileSearcher();
    }

    @NotNull
    protected String getProcessName() {
        if ("TSLint" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "getProcessName"));
        }
        return "TSLint";
    }

    @NotNull
    protected JSLanguageServiceQueue.ServiceInfoReporter createDefaultReporter() {
        JSLanguageServiceBase.NotificationLanguageServiceReporter notificationLanguageServiceReporter = new JSLanguageServiceBase.NotificationLanguageServiceReporter((JSLanguageServiceBase)this, JSLinterUtil.NOTIFICATION_GROUP, super.createDefaultReporter());
        if (notificationLanguageServiceReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "createDefaultReporter"));
        }
        return notificationLanguageServiceReporter;
    }

    public final Future<List<TsLinterError>> highlight(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable String content) {
        JSLanguageServiceQueue process = this.getProcess();
        if (TsLintLanguageService.checkParameters(virtualFile, process)) {
            return new FixedFuture(Collections.singletonList(new TsLinterError("Path not specified")));
        }
        String configPath = config == null ? null : JSLanguageServiceUtil.normalizeNameAndPath((VirtualFile)config);
        String path = JSLanguageServiceUtil.normalizeNameAndPath((VirtualFile)virtualFile);
        if (path == null) {
            return new FixedFuture(Collections.singletonList(new TsLinterError("Can not work with the path: " + virtualFile.getPath())));
        }
        TsLintGetErrorsCommand command = new TsLintGetErrorsCommand(path, configPath, StringUtil.notNullize((String)content));
        return process.execute((JSLanguageServiceCommand)command, TsLintLanguageService.createHighlightProcessor(path));
    }

    public final Future<List<TsLinterError>> highlightAndFix(@Nullable VirtualFile virtualFile, @NotNull TsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "highlightAndFix"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (TsLintLanguageService.checkParameters(virtualFile, process)) {
            return new FixedFuture(Collections.singletonList(new TsLinterError("Path not specified")));
        }
        VirtualFile config = this.myConfigFileSearcher.getConfig(state, virtualFile);
        String configPath = config == null ? null : JSLanguageServiceUtil.normalizeNameAndPath((VirtualFile)config);
        String path = JSLanguageServiceUtil.normalizeNameAndPath((VirtualFile)virtualFile);
        if (path == null) {
            return null;
        }
        TsLintFixErrorsCommand command = new TsLintFixErrorsCommand(path, configPath);
        return process.execute((JSLanguageServiceCommand)command, TsLintLanguageService.createHighlightProcessor(path));
    }

    private static boolean checkParameters(@Nullable VirtualFile virtualFile, JSLanguageServiceQueue process) {
        return process == null || virtualFile == null || !virtualFile.isInLocalFileSystem();
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<List<TsLinterError>> createHighlightProcessor(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "createHighlightProcessor"));
        }
        JSLanguageServiceCommandProcessor jSLanguageServiceCommandProcessor = (object, answer) -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "lambda$createHighlightProcessor$0"));
            }
            return TsLintLanguageService.parseResults(answer, path);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "createHighlightProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private static List<TsLinterError> parseResults(@NotNull JSLanguageServiceAnswer answer, @NotNull String path) {
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "parseResults"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "parseResults"));
        }
        JsonObject element = answer.getElement();
        JsonElement error = element.get("error");
        if (error != null) {
            return Collections.singletonList(new TsLinterError(error.getAsString()));
        }
        JsonElement body = TsLintLanguageService.parseBody(element);
        if (body == null) {
            return null;
        }
        String version = element.get("version").getAsString();
        SemVer tsLintVersion = SemVer.parseFromText((String)version);
        boolean isZeroBased = TsLintOutputJsonParser.isVersionZeroBased(tsLintVersion);
        TsLintOutputJsonParser parser = new TsLintOutputJsonParser(path, body, isZeroBased);
        return ContainerUtil.newArrayList(parser.getErrors());
    }

    private static JsonElement parseBody(@NotNull JsonObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "parseBody"));
        }
        JsonElement body = element.get("body");
        if (body == null) {
            return null;
        }
        if (body.isJsonPrimitive() && body.getAsJsonPrimitive().isString()) {
            String bodyContent = StringUtil.unquoteString((String)body.getAsJsonPrimitive().getAsString());
            if (!StringUtil.isEmptyOrSpaces((String)bodyContent)) {
                try {
                    return new JsonParser().parse(bodyContent);
                }
                catch (JsonParseException e) {
                    LOG.info(String.format("Problem parsing body: '%s'\n%s", body, e.getMessage()), (Throwable)e);
                }
            }
        } else {
            LOG.info(String.format("Error body type, should be a string with json inside. Body:'%s'", body.getAsString()));
        }
        return null;
    }

    protected final JSLanguageServiceQueue createLanguageServiceQueue() {
        TsLintLanguageServiceProtocol protocol = new TsLintLanguageServiceProtocol(this.myProject, el -> {});
        return new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)protocol, this.myProcessConnector, this.myDefaultReporter, (JSLanguageServiceCacheData)new JSLanguageServiceDefaultCacheData());
    }

    protected final boolean needInitToolWindow() {
        return false;
    }
}

