/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.ui;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService;
import com.intellij.lang.javascript.linter.tslint.ui.TsLintView;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TsLintConfigurable
extends JSLinterConfigurable<TsLintState> {
    @NonNls
    public static final String SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT = "settings.javascript.linters.tslint";

    public TsLintConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable", "<init>"));
        }
        super(project, TsLintConfiguration.class, false);
    }

    public TsLintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable", "<init>"));
        }
        super(project, TsLintConfiguration.class, fullModeDialog);
    }

    @NotNull
    protected JSLinterBaseView<TsLintState> createView() {
        TsLintView tsLintView = new TsLintView(this.getProject(), this.isFullModeDialog());
        if (tsLintView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable", "createView"));
        }
        return tsLintView;
    }

    @NotNull
    public String getId() {
        if (SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable", "getId"));
        }
        return SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT;
    }

    @Nls
    public String getDisplayName() {
        return "TSLint";
    }

    public void apply() throws ConfigurationException {
        super.apply();
        TsLintState state = (TsLintState)this.getExtendedState(TsLintConfiguration.class).getState();
        if (!StringUtil.isEmptyOrSpaces((String)state.getPackagePath()) && state.isAllowJs() && !TsLintConfigurable.checkPackageVersionForJs(state.getPackagePath())) {
            throw new ConfigurationException("Linting JavaScript is not supported for this version of TSLint.");
        }
        TsLintLanguageService service = TsLintLanguageService.getService(this.myProject);
        service.terminateStartedProcess(false);
    }

    private static boolean checkPackageVersionForJs(String packagePath) {
        VirtualFile packageJson;
        VirtualFile packageVf = LocalFileSystem.getInstance().findFileByPath(packagePath);
        if (packageVf != null && (packageJson = packageVf.findChild("package.json")) != null) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData((VirtualFile)packageJson);
            return data.getVersion() != null && data.getVersion().getMajor() >= 4;
        }
        return false;
    }
}

