/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.ui;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.NodeModuleConfigurationView;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.ide.TsLintConfigFileType;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.File;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintView
extends JSLinterBaseView<TsLintState> {
    private static final JSLinterConfigFileTexts CONFIG_TEXTS = TsLintView.getConfigTexts();
    private final Project myProject;
    private final boolean myDialog;
    private final NodeModuleConfigurationView myNodeModuleConfigurationView;
    private final JSLinterConfigFileView myConfigFileView;
    private TextFieldWithBrowseButton myRules;
    private JBCheckBox myAllowJs;

    public TsLintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/ui/TsLintView", "<init>"));
        }
        super(fullModeDialog);
        this.myProject = project;
        this.myDialog = fullModeDialog;
        this.myConfigFileView = new JSLinterConfigFileView(project, CONFIG_TEXTS, (FileType)TsLintConfigFileType.INSTANCE);
        this.myConfigFileView.setAdditionalConfigFilesProducer(() -> {
            File homeFile;
            String home = System.getProperty("user.home");
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            VirtualFile homeVf = lfs.findFileByIoFile(homeFile = new File(home));
            if (homeVf == null) {
                homeVf = lfs.refreshAndFindFileByIoFile(homeFile);
            }
            if (homeVf == null) {
                return Collections.emptyList();
            }
            VirtualFile config = homeVf.findChild("tslint.json");
            if (config == null) {
                config = lfs.refreshAndFindFileByIoFile(new File(homeFile, "tslint.json"));
            }
            if (config == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(config);
        });
        this.myNodeModuleConfigurationView = new NodeModuleConfigurationView(project, "tslint", "TSLint", null);
    }

    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @NotNull
    protected Component createCenterComponent() {
        this.myRules = new TextFieldWithBrowseButton();
        this.myAllowJs = new JBCheckBox();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)this.myProject, (TextFieldWithBrowseButton)this.myRules, (String)"Select additional rules directory", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        FormBuilder nodeFieldsWrapperBuilder = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addLabeledComponent("&Node interpreter:", (JComponent)this.myNodeModuleConfigurationView.getNodeInterpreterField()).addLabeledComponent("TSLint package:", (JComponent)this.myNodeModuleConfigurationView.getPackageField());
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addComponent((JComponent)nodeFieldsWrapperBuilder.getPanel()).addComponent((JComponent)this.myConfigFileView.getComponent()).addSeparator(4).addVerticalGap(4).addLabeledComponent("Additional rules directory:", (JComponent)this.myRules).addLabeledComponent("Lint JavaScript files:", (JComponent)this.myAllowJs).getPanel();
        JPanel centerPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel jPanel = centerPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/ui/TsLintView", "createCenterComponent"));
        }
        return jPanel;
    }

    protected void handleEnableStatusChanged(boolean enabled) {
        this.enableCustomConfigPath(enabled);
    }

    @NotNull
    protected TsLintState getState() {
        TsLintState.Builder builder = new TsLintState.Builder().setNodePath(this.myNodeModuleConfigurationView.getNodeInterpreterField().getInterpreterRef()).setPackagePath(this.myNodeModuleConfigurationView.getPackageField().getSelected().getSystemDependentPath()).setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed()).setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath()).setAllowJs(this.myAllowJs.isSelected());
        if (!StringUtil.isEmptyOrSpaces((String)this.myRules.getText())) {
            builder.setRulesDirectory(this.myRules.getText().trim());
        }
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/ui/TsLintView", "getState"));
        }
        return tsLintState;
    }

    protected void setState(@NotNull TsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/ui/TsLintView", "setState"));
        }
        this.myNodeModuleConfigurationView.getNodeInterpreterField().setInterpreterRef(state.getInterpreterRef());
        this.myNodeModuleConfigurationView.getPackageField().setSelected(new NodePackage(state.getPackagePath()));
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(StringUtil.notNullize((String)state.getCustomConfigFilePath()));
        if (!StringUtil.isEmptyOrSpaces((String)state.getRulesDirectory())) {
            this.myRules.setText(state.getRulesDirectory());
        }
        this.myAllowJs.setSelected(state.isAllowJs());
        this.resizeOnSeparateDialog();
    }

    private void resizeOnSeparateDialog() {
        if (this.isFullModeDialog()) {
            this.myNodeModuleConfigurationView.setPreferredWidthToComponents();
            this.myConfigFileView.setPreferredWidthToComponents();
        }
    }

    private void enableCustomConfigPath(boolean enabled) {
        this.myConfigFileView.onEnabledStateChanged(enabled);
    }

    private static JSLinterConfigFileTexts getConfigTexts() {
        return new JSLinterConfigFileTexts("Search for tslint.json", "When linting a TypeScript file, TSLint looks for tslint.json starting from the file's folder and then moving up to the filesystem root or in the user's home directory.", "Select TSLint configuration file (*.json)");
    }
}

