/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.actions;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class GherkinStepParameterSelectioner
extends AbstractWordSelectioner {
    private static final Set<Pair<String, String>> START_END = new LinkedHashSet<Pair<String, String>>();

    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "canSelect"));
        }
        return e.getParent() instanceof GherkinStep || e.getParent() instanceof GherkinStepsHolder;
    }

    @NotNull
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement parent;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "select"));
        }
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "select"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "select"));
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        if (editor.getSettings().isCamelWords()) {
            result.addAll(super.select(e, editorText, cursorOffset, editor));
        }
        if ((parent = e.getParent()) instanceof GherkinStep) {
            GherkinStep step = (GherkinStep)parent;
            for (PsiReference reference : step.getReferences()) {
                List<TextRange> ranges;
                AbstractStepDefinition definition;
                if (!(reference instanceof CucumberStepReference) || DumbService.isDumb((Project)step.getProject()) || (definition = ((CucumberStepReference)reference).resolveToDefinition()) == null || (ranges = GherkinPsiUtil.buildParameterRanges(step, definition, step.getTextOffset() + reference.getRangeInElement().getStartOffset())) == null) continue;
                result.addAll(ranges);
                result.addAll(GherkinStepParameterSelectioner.buildAdditionalRanges(ranges, editorText));
            }
            GherkinStepParameterSelectioner.buildAdditionalRanges(result, editorText);
        } else if (parent instanceof GherkinStepsHolder) {
            ASTNode keyword;
            ASTNode stepHolderNode = parent.getNode();
            if (stepHolderNode != null && (keyword = stepHolderNode.findChildByType(GherkinTokenTypes.KEYWORDS)) != null) {
                result.add(TextRange.create((int)keyword.getTextRange().getStartOffset(), (int)parent.getTextRange().getEndOffset()));
            }
            result.add(parent.getTextRange());
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "select"));
        }
        return arrayList;
    }

    @NotNull
    private static List<TextRange> buildAdditionalRanges(@NotNull List<TextRange> ranges, @NotNull CharSequence editorText) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "buildAdditionalRanges"));
        }
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "buildAdditionalRanges"));
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        for (TextRange textRange : ranges) {
            if (textRange.isEmpty()) continue;
            GherkinStepParameterSelectioner.addRangesForText(result, textRange, editorText);
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "buildAdditionalRanges"));
        }
        return arrayList;
    }

    private static void addRangesForText(@NotNull List<TextRange> result, @NotNull TextRange textRange, @NotNull CharSequence charSequence) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "addRangesForText"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "addRangesForText"));
        }
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "org/jetbrains/plugins/cucumber/actions/GherkinStepParameterSelectioner", "addRangesForText"));
        }
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        String text = charSequence.subSequence(startOffset, endOffset).toString();
        for (Pair<String, String> startEnd : START_END) {
            TextRange newRange;
            String textWithEdges;
            TextRange newRange2;
            String start = (String)startEnd.first;
            String end = (String)startEnd.second;
            if (text.startsWith(start) && text.endsWith(end) && !(newRange2 = TextRange.create((int)(startOffset + start.length()), (int)(endOffset - end.length()))).isEmpty()) {
                result.add(newRange2);
                GherkinStepParameterSelectioner.addRangesForText(result, newRange2, charSequence);
            }
            int startOffsetWithEdge = startOffset - start.length();
            int endOffsetWithEdge = endOffset + end.length();
            if (startOffsetWithEdge < 0 || endOffsetWithEdge > charSequence.length() || !(textWithEdges = charSequence.subSequence(startOffsetWithEdge, endOffsetWithEdge).toString()).startsWith(start) || !textWithEdges.endsWith(end) || (newRange = TextRange.create((int)startOffsetWithEdge, (int)endOffsetWithEdge)).isEmpty()) continue;
            result.add(newRange);
        }
    }

    static {
        START_END.add((Pair<String, String>)Pair.create((Object)"'", (Object)"'"));
        START_END.add((Pair<String, String>)Pair.create((Object)"\"", (Object)"\""));
        START_END.add((Pair<String, String>)Pair.create((Object)"<", (Object)">"));
        START_END.add((Pair<String, String>)Pair.create((Object)"(", (Object)")"));
        START_END.add((Pair<String, String>)Pair.create((Object)"[", (Object)"]"));
    }
}

