/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.codeinsight;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class GherkinTypedHandler
extends TypedHandlerDelegate {
    public static final char PIPE = '|';

    @Nullable
    private static GherkinTable getTable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler", "getTable"));
        }
        while (element != null && !(element instanceof GherkinTable)) {
            element = element.getParent();
        }
        return (GherkinTable)element;
    }

    @Nullable
    private static GherkinTableRow findCurrentRow(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler", "findCurrentRow"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler", "findCurrentRow"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement cursorElement = file.findElementAt(offset - 1);
        if (cursorElement == null) {
            return null;
        }
        GherkinTable element = GherkinTypedHandler.getTable(cursorElement);
        if (element == null) {
            if ((cursorElement = file.findElementAt(offset - cursorElement.getTextLength())) == null) {
                return null;
            }
            element = GherkinTypedHandler.getTable(cursorElement);
            if (element == null) {
                return null;
            }
        }
        GherkinTable table = element;
        int tableOffset = table.getTextOffset();
        int caretOffsetInParent = editor.getCaretModel().getOffset() - tableOffset;
        ArrayList<GherkinTableRow> rowList = new ArrayList<GherkinTableRow>();
        if (table.getHeaderRow() != null) {
            rowList.add(table.getHeaderRow());
        }
        rowList.addAll(table.getDataRows());
        for (int i = 0; i < rowList.size() - 1; ++i) {
            GherkinTableRow row = (GherkinTableRow)rowList.get(i);
            GherkinTableRow nextRow = (GherkinTableRow)rowList.get(i + 1);
            int start = row.getStartOffsetInParent();
            int end = start + row.getTextLength();
            if (start <= caretOffsetInParent && caretOffsetInParent <= end) {
                return row;
            }
            if (end >= caretOffsetInParent || caretOffsetInParent > nextRow.getStartOffsetInParent()) continue;
            return row;
        }
        return (GherkinTableRow)rowList.get(rowList.size() - 1);
    }

    @Nullable
    private static GherkinTableRow getPreviousRow(@NotNull GherkinTableRow currentRow) {
        if (currentRow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRow", "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler", "getPreviousRow"));
        }
        if (currentRow.getParent() != null && currentRow.getParent() instanceof GherkinTable) {
            GherkinTable table = (GherkinTable)currentRow.getParent();
            int i = table.getDataRows().indexOf(currentRow);
            if (i > 0) {
                return table.getDataRows().get(i - 1);
            }
            if (i == 0) {
                return table.getHeaderRow();
            }
        }
        return null;
    }

    private static int getColumnNumber(@NotNull GherkinTableRow row, int caretPosition) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler", "getColumnNumber"));
        }
        String rowText = row.getText();
        int length = Math.min(caretPosition, rowText.length());
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (rowText.charAt(i) != '|') continue;
            ++count;
        }
        return count - 1;
    }

    private static String getSpaceLine(int n) {
        char[] spaces = new char[n];
        Arrays.fill(spaces, ' ');
        StringBuilder sb = new StringBuilder(n);
        sb.append(spaces);
        return sb.toString();
    }

    private static int getPreferredPipeOffset(@NotNull GherkinTableRow row, int columnNumber) {
        int i;
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler", "getPreferredPipeOffset"));
        }
        String rowText = row.getText();
        int passedPipeCount = 0;
        for (i = 0; i < rowText.length() && passedPipeCount - 2 < columnNumber; ++i) {
            if (rowText.charAt(i) != '|') continue;
            ++passedPipeCount;
        }
        return passedPipeCount - 2 == columnNumber ? i : -1;
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        int cellNumber;
        int rightPosition;
        int offsetInParent;
        GherkinTableRow previousRow;
        GherkinTableRow currentRow;
        if (fileType.equals((Object)GherkinFileType.INSTANCE) && c == '|' && (currentRow = GherkinTypedHandler.findCurrentRow(editor, file)) != null && (previousRow = GherkinTypedHandler.getPreviousRow(currentRow)) != null && (offsetInParent = editor.getCaretModel().getOffset() - currentRow.getTextOffset()) < (rightPosition = GherkinTypedHandler.getPreferredPipeOffset(previousRow, cellNumber = GherkinTypedHandler.getColumnNumber(currentRow, offsetInParent))) - 1) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)GherkinTypedHandler.getSpaceLine(rightPosition - offsetInParent - 1));
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }
}

