/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementFactory;

public class CucumberAddExamplesColonFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        if ("Add missing ':' after examples keyword" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberAddExamplesColonFix", "getFamilyName"));
        }
        return "Add missing ':' after examples keyword";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/inspections/CucumberAddExamplesColonFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/cucumber/inspections/CucumberAddExamplesColonFix", "applyFix"));
        }
        PsiElement examples = descriptor.getPsiElement();
        PsiElement[] elements = GherkinElementFactory.getTopLevelElements(project, ":");
        examples.getParent().addAfter(elements[0], examples);
    }
}

