/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;

public class GherkinFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final TokenSet BLOCKS_TO_FOLD = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.SCENARIO, GherkinElementTypes.SCENARIO_OUTLINE, GherkinElementTypes.EXAMPLES_BLOCK, GherkinTokenTypes.PYSTRING});

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/cucumber/psi/GherkinFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/cucumber/psi/GherkinFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        this.appendDescriptors(node, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private void appendDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (BLOCKS_TO_FOLD.contains(node.getElementType()) && node.getTextRange().getLength() >= 2) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, descriptors);
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/cucumber/psi/GherkinFoldingBuilder", "getPlaceholderText"));
        }
        if (node.getPsi() instanceof GherkinStepsHolder || node.getPsi() instanceof GherkinExamplesBlockImpl) {
            return ((NavigationItem)node.getPsi()).getPresentation().getPresentableText();
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/cucumber/psi/GherkinFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

